/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf90;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;

public final class SetSmfSection
extends SmfData {
    public static final int SMF90PAL = 128;
    public static final int SMF90PLT = 64;
    public static final int SMF90PIP = 32;
    public static final int SMF90PNO = 16;
    public static final int SMF90RPR = 8;
    public static final int SMF90RAL = 4;
    public static final int SMF90LDS = 2;
    public static final int SMF90NLD = 1;
    public static final int SMF90NBM = 128;
    public static final int SMF90NBH = 64;
    public static final int SMF90LDM = 32;
    public static final int SMF90LDH = 16;
    public static final int SMF90TSS = 8;
    public static final int SMF90NSS = 4;
    public static final int SMF90S3C = 2;
    public static final int SMF90N3C = 1;
    public static final int SMF90SDF = 128;
    public static final int SMF90SON = 64;
    public static final int SMF90SSE = 32;
    public static final int SMF90SSY = 16;
    public static final int SMF90SCO = 4;

    private SetSmfSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public Duration smf90max() {
        return Util.EBCDIC4mmss(this.data, 0);
    }

    public double smf90maxSeconds() {
        return Util.ToSeconds(this.smf90max());
    }

    public String smf90maxRawValue() {
        return Util.ConvertEbcdic(this.data, 0, 4);
    }

    public LocalTime smf90sta() {
        return Util.EBCDIC6hhmmss(this.data, 4);
    }

    public String smf90staRawValue() {
        return Util.ConvertEbcdic(this.data, 4, 6);
    }

    public Duration smf90jwt() {
        return Util.EBCDIC4hhmm(this.data, 10);
    }

    public String smf90jwtRawValue() {
        return Util.ConvertEbcdic(this.data, 10, 4);
    }

    public String smf90syi() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public int smf90swt() {
        return Util.ConvertUnsignedBinary1(this.data, 20);
    }

    public boolean smf90pal() {
        return Util.ConvertFlag(this.data, this.smf90swt(), 128);
    }

    public boolean smf90plt() {
        return Util.ConvertFlag(this.data, this.smf90swt(), 64);
    }

    public boolean smf90pip() {
        return Util.ConvertFlag(this.data, this.smf90swt(), 32);
    }

    public boolean smf90pno() {
        return Util.ConvertFlag(this.data, this.smf90swt(), 16);
    }

    public boolean smf90rpr() {
        return Util.ConvertFlag(this.data, this.smf90swt(), 8);
    }

    public boolean smf90ral() {
        return Util.ConvertFlag(this.data, this.smf90swt(), 4);
    }

    public boolean smf90lds() {
        return Util.ConvertFlag(this.data, this.smf90swt(), 2);
    }

    public boolean smf90nld() {
        return Util.ConvertFlag(this.data, this.smf90swt(), 1);
    }

    public int smf90sw2() {
        return Util.ConvertUnsignedBinary1(this.data, 21);
    }

    public boolean smf90nbm() {
        return Util.ConvertFlag(this.data, this.smf90sw2(), 128);
    }

    public boolean smf90nbh() {
        return Util.ConvertFlag(this.data, this.smf90sw2(), 64);
    }

    public boolean smf90ldm() {
        return Util.ConvertFlag(this.data, this.smf90sw2(), 32);
    }

    public boolean smf90ldh() {
        return Util.ConvertFlag(this.data, this.smf90sw2(), 16);
    }

    public boolean smf90tss() {
        return Util.ConvertFlag(this.data, this.smf90sw2(), 8);
    }

    public boolean smf90nss() {
        return Util.ConvertFlag(this.data, this.smf90sw2(), 4);
    }

    public boolean smf90s3c() {
        return Util.ConvertFlag(this.data, this.smf90sw2(), 2);
    }

    public boolean smf90n3c() {
        return Util.ConvertFlag(this.data, this.smf90sw2(), 1);
    }

    public int smf90sbu() {
        return Util.ConvertUnsignedBinary1(this.data, 22);
    }

    public boolean smf90sdf() {
        return Util.ConvertFlag(this.data, this.smf90sbu(), 128);
    }

    public boolean smf90son() {
        return Util.ConvertFlag(this.data, this.smf90sbu(), 64);
    }

    public boolean smf90sse() {
        return Util.ConvertFlag(this.data, this.smf90sbu(), 32);
    }

    public boolean smf90ssy() {
        return Util.ConvertFlag(this.data, this.smf90sbu(), 16);
    }

    public boolean smf90sco() {
        return Util.ConvertFlag(this.data, this.smf90sbu(), 4);
    }

    public String smf90rel() {
        return Util.ConvertEbcdic(this.data, 24, 4);
    }

    public LocalTime smf90iit() {
        return Util.Binary4x100STime(this.data, 28);
    }

    public long smf90iitRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public LocalDate smf90idt() {
        return Util.SMFDate(this.data, 32);
    }

    public int smf90idtRawValue() {
        return Util.ConvertPacked4(this.data, 32);
    }

    public String smf90bfm() {
        return Util.ConvertEbcdic(this.data, 36, 5);
    }

    public String smf90bfl() {
        return Util.ConvertEbcdic(this.data, 41, 2);
    }

    public String smf90eswt() {
        return Util.ConvertEbcdic(this.data, 43, 4);
    }

    public String smf90etwt() {
        return Util.ConvertEbcdic(this.data, 47, 4);
    }

    public static SetSmfSection create(byte[] Data2, int offset, int length) {
        return new SetSmfSection(Data2, offset, length);
    }

    static enum Field {
        smf90max(0, 4),
        smf90sta(4, 6),
        smf90jwt(10, 4),
        smf90syi(14, 4),
        smf90swt(20, 1),
        smf90sw2(21, 1),
        smf90sbu(22, 1),
        smf90rel(24, 4),
        smf90iit(28, 4),
        smf90idt(32, 4),
        smf90bfm(36, 5),
        smf90bfl(41, 2),
        smf90eswt(43, 4),
        smf90etwt(47, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

