/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf90;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.NotYetCreatedException;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf90.ArmPolicySection;
import com.blackhillsoftware.smf.smf90.CapacityChangeSection;
import com.blackhillsoftware.smf.smf90.CvtlsoChange;
import com.blackhillsoftware.smf.smf90.DynamicApfSection;
import com.blackhillsoftware.smf.smf90.DynamicLpaSection;
import com.blackhillsoftware.smf.smf90.IefopzConfigurationSection;
import com.blackhillsoftware.smf.smf90.IefopzDDJobnameSection;
import com.blackhillsoftware.smf.smf90.IefopzOldNewSection;
import com.blackhillsoftware.smf.smf90.InstallServiceDefinitionSection;
import com.blackhillsoftware.smf.smf90.IplPromptSection;
import com.blackhillsoftware.smf.smf90.IplSrmSection;
import com.blackhillsoftware.smf.smf90.LinklstActivationSection;
import com.blackhillsoftware.smf.smf90.LogrecDatasetSection;
import com.blackhillsoftware.smf.smf90.Lpmea;
import com.blackhillsoftware.smf.smf90.ModifyWlmSection;
import com.blackhillsoftware.smf.smf90.ProductHeader;
import com.blackhillsoftware.smf.smf90.ResetCommandSection;
import com.blackhillsoftware.smf.smf90.SchedulingEnvironmentBuilder;
import com.blackhillsoftware.smf.smf90.ServicePolicyBuilder;
import com.blackhillsoftware.smf.smf90.SetAppcSection;
import com.blackhillsoftware.smf.smf90.SetAschSection;
import com.blackhillsoftware.smf.smf90.SetAutoReplySection;
import com.blackhillsoftware.smf.smf90.SetCngrpSection;
import com.blackhillsoftware.smf.smf90.SetConSection;
import com.blackhillsoftware.smf.smf90.SetDaeSection;
import com.blackhillsoftware.smf.smf90.SetDateTimeSection;
import com.blackhillsoftware.smf.smf90.SetGrsRnlSection;
import com.blackhillsoftware.smf.smf90.SetLoadIeasymSection;
import com.blackhillsoftware.smf.smf90.SetMpfSection;
import com.blackhillsoftware.smf.smf90.SetOptSection;
import com.blackhillsoftware.smf.smf90.SetPfkSection;
import com.blackhillsoftware.smf.smf90.SetSchSection;
import com.blackhillsoftware.smf.smf90.SetSmfLimSection;
import com.blackhillsoftware.smf.smf90.SetSmfSection;
import com.blackhillsoftware.smf.smf90.SmfDatasetSection;
import com.blackhillsoftware.smf.smf90.SmfInfoHeader;
import com.blackhillsoftware.smf.smf90.SmfSubsystemParameterSection;
import com.blackhillsoftware.smf.smf90.SmfSubsystemRecordSection;
import com.blackhillsoftware.smf.smf90.SmfSwitchSection;
import com.blackhillsoftware.smf.smf90.SystemRecoveryBoostSection;
import com.blackhillsoftware.smf.smf90.ValidatedBootAuditEntry;
import com.blackhillsoftware.smf.smf90.ValidatedBootBadCX;
import com.blackhillsoftware.smf.smf90.ValidatedBootCX;
import com.blackhillsoftware.smf.smf90.ValidatedBootHeader;
import com.blackhillsoftware.smf.smf90.WlmSchedulingEnvironmentSection;
import com.blackhillsoftware.smf.smf90.WlmServicePolicySection;
import com.blackhillsoftware.svpol.ServicePolicy;
import com.blackhillsoftware.svpse.SchedulingEnvironment;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class Smf90Record
extends SmfRecord {
    private List<ProductHeader> m_ProductHeaders = null;
    private SetDateTimeSection m_SetDateTimeSection = null;
    private SmfInfoHeader m_SmfInfoHeader = null;
    private List<SetSmfSection> m_SetSmfSections = null;
    private List<SmfDatasetSection> m_SmfDatasetSections = null;
    private List<SmfSubsystemRecordSection> m_SmfSubsystemRecordSection = null;
    private List<SmfSubsystemParameterSection> m_SmfSubsystemParameterSection = null;
    private List<SmfSwitchSection> m_SmfSwitchSection = null;
    private List<IplPromptSection> m_IplPromptSection = null;
    private List<IplSrmSection> m_IplSrmSection = null;
    private List<SetOptSection> m_SetOptSection = null;
    private List<SetMpfSection> m_SetMpfSection = null;
    private List<SetDaeSection> m_SetDaeSection = null;
    private List<SetPfkSection> m_SetPfkSection = null;
    private List<SetGrsRnlSection> m_SetGrsRnlSection = null;
    private List<SetAppcSection> m_SetAppcSection = null;
    private List<SetAschSection> m_SetAschSection = null;
    private List<SetSchSection> m_SetSchSection = null;
    private List<SetCngrpSection> m_SetCngrpSection = null;
    private InstallServiceDefinitionSection m_InstallServiceDefinitionSection = null;
    private WlmServicePolicySection m_WlmServicePolicySection = null;
    private ServicePolicy m_ServicePolicy = null;
    private List<ModifyWlmSection> m_ModifyWlmSection = null;
    private List<LogrecDatasetSection> m_LogrecDatasetSection = null;
    private List<ArmPolicySection> m_ArmPolicySection = null;
    private List<LinklstActivationSection> m_LinklstActivationSection = null;
    private List<ResetCommandSection> m_ResetCommandSection = null;
    private List<DynamicLpaSection> m_DynamicLpaSection = null;
    private List<Lpmea> m_Lpmea = null;
    private WlmSchedulingEnvironmentSection m_WlmSchedulingEnvironmentSection = null;
    private SchedulingEnvironment m_SchedulingEnvironment = null;
    private List<SetAutoReplySection> m_SetAutoReplySection = null;
    private List<CapacityChangeSection> m_CapacityChangeSection = null;
    private List<SetLoadIeasymSection> m_SetLoadIeasymSection = null;
    private List<SetConSection> m_SetConSection = null;
    private List<DynamicApfSection> m_DynamicApfSection = null;
    private List<IefopzConfigurationSection> m_IefopzConfigurationSection = null;
    private List<IefopzOldNewSection> m_IefopzOldNewSection = null;
    private List<IefopzDDJobnameSection> m_IefopzDDJobnameSection = null;
    private List<SetSmfLimSection> m_SetSmfLimSection = null;
    private List<SystemRecoveryBoostSection> m_SystemRecoveryBoostSection = null;
    private CvtlsoChange m_CvtlsoChange = null;
    private ValidatedBootHeader m_ValidatedBootHeader = null;
    private List<ValidatedBootAuditEntry> m_ValidatedBootAuditEntry = null;
    private List<ValidatedBootCX> m_ValidatedBootCX = null;
    private List<ValidatedBootBadCX> m_ValidatedBootBadCX = null;

    public Smf90Record(byte[] data) {
        super(data);
        if (this.recordType() != 90) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf90Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 90) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf90Record from(SmfRecord record) {
        return new Smf90Record(record);
    }

    public static Smf90Record from(byte[] data) {
        return new Smf90Record(data);
    }

    public String event() {
        switch (this.productHeader().smf90tid()) {
            case 1: {
                return "SET TIME";
            }
            case 2: {
                return "SET DATE";
            }
            case 5: {
                return "SET SMF";
            }
            case 6: {
                return "SWITCH SMF";
            }
            case 7: {
                return "HALT EOD";
            }
            case 8: {
                return "IPL PROMPT";
            }
            case 9: {
                return "IPL SMF";
            }
            case 10: {
                return "IPL SRM";
            }
            case 11: {
                return "SET OPT";
            }
            case 13: {
                return "SETSMF";
            }
            case 14: {
                return "SET MPF";
            }
            case 15: {
                return "SET SMF (restart SMF)";
            }
            case 16: {
                return "SET DAE";
            }
            case 17: {
                return "SET PFK";
            }
            case 18: {
                return "SET GRSRNL";
            }
            case 19: {
                return "SET APPC";
            }
            case 20: {
                return "SET ASCH";
            }
            case 21: {
                return "SET SCH";
            }
            case 22: {
                return "SET CNGRP";
            }
            case 23: {
                return "Install WLM Service Definition";
            }
            case 24: {
                return "VARY WLM";
            }
            case 25: {
                return "MODIFY WLM";
            }
            case 26: {
                return "IPL LOGREC";
            }
            case 27: {
                return "SETXCF START (enable automatic restart management)";
            }
            case 28: {
                return "SETXCF STOP (disable automatic restart management)";
            }
            case 29: {
                return "SET PROG (LNKLST activation)";
            }
            case 30: {
                return "RESET";
            }
            case 31: {
                return "SET PROG (LPALST activation)";
            }
            case 32: {
                return "WLM policy change";
            }
            case 33: {
                return "SET AUTOR";
            }
            case 34: {
                return "Processor capacity change";
            }
            case 35: {
                return "SETLOAD xx,IEASYM";
            }
            case 36: {
                return "SET CON";
            }
            case 37: {
                return "Dynamic APF";
            }
            case 38: {
                return "SET IEFOPZ";
            }
            case 39: {
                return "SET SMFLIM";
            }
            case 40: {
                return "Boost information";
            }
            case 41: {
                return "CVTLSO change";
            }
            case 42: {
                return "Validated Boot";
            }
        }
        return "Unknown";
    }

    public int smf90len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf90seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf90flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf90rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf90tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf90tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf90dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf90dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf90sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public int smf90pof() {
        return Util.ConvertSignedBinary4(this.data, 20);
    }

    public int smf90pln() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int smf90pon() {
        return Util.ConvertUnsignedBinary2(this.data, 26);
    }

    public int smf90dof() {
        return Util.ConvertSignedBinary4(this.data, 28);
    }

    public int smf90dln() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf90don() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public ProductHeader productHeader() {
        return this.productHeaders().get(0);
    }

    public List<ProductHeader> productHeaders() {
        if (this.m_ProductHeaders != null) {
            return this.m_ProductHeaders;
        }
        int count = this.smf90pon();
        if (count == 0) {
            return Collections.emptyList();
        }
        int length = this.smf90pln();
        int offset = this.smf90pof();
        ArrayList<ProductHeader> result = new ArrayList<ProductHeader>(count);
        for (int i = 0; i < count; ++i) {
            result.add(ProductHeader.create(this.data, offset + i * length, length));
        }
        this.m_ProductHeaders = Collections.unmodifiableList(result);
        return this.m_ProductHeaders;
    }

    public SetDateTimeSection setDateTime() {
        if (this.m_SetDateTimeSection != null) {
            return this.m_SetDateTimeSection;
        }
        switch (this.productHeader().smf90tid()) {
            case 1: 
            case 2: {
                int length = this.smf90dln();
                int offset = this.smf90dof();
                this.m_SetDateTimeSection = SetDateTimeSection.create(this.data, offset, length);
                return this.m_SetDateTimeSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 1 and 2 records");
    }

    public SmfInfoHeader smfInfoHeader() {
        if (this.m_SmfInfoHeader != null) {
            return this.m_SmfInfoHeader;
        }
        switch (this.productHeader().smf90tid()) {
            case 5: 
            case 9: 
            case 13: 
            case 15: {
                int length = 32;
                int offset = this.smf90dof();
                this.m_SmfInfoHeader = SmfInfoHeader.create(this.data, offset, length);
                return this.m_SmfInfoHeader;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 5, 9, 13 and 15 records");
    }

    public List<SetSmfSection> setSmfSections() {
        if (this.m_SetSmfSections != null) {
            return this.m_SetSmfSections;
        }
        int count = this.smfInfoHeader().smf90nsm();
        if (count == 0) {
            return Collections.emptyList();
        }
        int length = this.smfInfoHeader().smf90lsm();
        int offset = this.smfInfoHeader().smf90osm();
        ArrayList<SetSmfSection> result = new ArrayList<SetSmfSection>(count);
        for (int i = 0; i < count; ++i) {
            result.add(SetSmfSection.create(this.data, offset + i * length, length));
        }
        this.m_SetSmfSections = Collections.unmodifiableList(result);
        return this.m_SetSmfSections;
    }

    public List<SmfDatasetSection> smfDatasetSections() {
        if (this.m_SmfDatasetSections != null) {
            return this.m_SmfDatasetSections;
        }
        int count = this.smfInfoHeader().smf90nda();
        if (count == 0) {
            return Collections.emptyList();
        }
        int length = this.smfInfoHeader().smf90lda();
        int offset = this.smfInfoHeader().smf90oda();
        ArrayList<SmfDatasetSection> result = new ArrayList<SmfDatasetSection>(count);
        for (int i = 0; i < count; ++i) {
            result.add(SmfDatasetSection.create(this.data, offset + i * length, length));
        }
        this.m_SmfDatasetSections = Collections.unmodifiableList(result);
        return this.m_SmfDatasetSections;
    }

    public List<SmfSubsystemRecordSection> smfSubsystemRecordSections() {
        if (this.m_SmfSubsystemRecordSection != null) {
            return this.m_SmfSubsystemRecordSection;
        }
        int count = this.smfInfoHeader().smf90nwk();
        if (count == 0) {
            return Collections.emptyList();
        }
        int length = this.smfInfoHeader().smf90lwk();
        int offset = this.smfInfoHeader().smf90owk();
        ArrayList<SmfSubsystemRecordSection> result = new ArrayList<SmfSubsystemRecordSection>(count);
        for (int i = 0; i < count; ++i) {
            result.add(SmfSubsystemRecordSection.create(this.data, offset + i * length, length));
        }
        this.m_SmfSubsystemRecordSection = Collections.unmodifiableList(result);
        return this.m_SmfSubsystemRecordSection;
    }

    public List<SmfSubsystemParameterSection> smfSubsystemParameterSections() {
        if (this.m_SmfSubsystemParameterSection != null) {
            return this.m_SmfSubsystemParameterSection;
        }
        int count = this.smfInfoHeader().smf90not();
        if (count == 0) {
            return Collections.emptyList();
        }
        int length = this.smfInfoHeader().smf90lot();
        int offset = this.smfInfoHeader().smf90oot();
        ArrayList<SmfSubsystemParameterSection> result = new ArrayList<SmfSubsystemParameterSection>(count);
        for (int i = 0; i < count; ++i) {
            result.add(SmfSubsystemParameterSection.create(this.data, offset + i * length, length));
        }
        this.m_SmfSubsystemParameterSection = Collections.unmodifiableList(result);
        return this.m_SmfSubsystemParameterSection;
    }

    public List<SmfSwitchSection> smfSwitchSections() {
        switch (this.productHeader().smf90tid()) {
            case 6: 
            case 7: {
                this.m_SmfSwitchSection = Util.sectionsFromTriplet(this.m_SmfSwitchSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), SmfSwitchSection::create);
                return this.m_SmfSwitchSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 6 and 7 records");
    }

    public List<IplPromptSection> iplPromptSection() {
        switch (this.productHeader().smf90tid()) {
            case 8: {
                this.m_IplPromptSection = Util.sectionsFromTriplet(this.m_IplPromptSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), IplPromptSection::create);
                return this.m_IplPromptSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 8 records");
    }

    public List<IplSrmSection> iplSrmSection() {
        switch (this.productHeader().smf90tid()) {
            case 10: {
                this.m_IplSrmSection = Util.sectionsFromTriplet(this.m_IplSrmSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), IplSrmSection::create);
                return this.m_IplSrmSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 10 records");
    }

    public List<SetOptSection> setOptSection() {
        switch (this.productHeader().smf90tid()) {
            case 11: {
                this.m_SetOptSection = Util.sectionsFromTriplet(this.m_SetOptSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), SetOptSection::create);
                return this.m_SetOptSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 11 records");
    }

    public List<SetMpfSection> setMpfSection() {
        switch (this.productHeader().smf90tid()) {
            case 14: {
                this.m_SetMpfSection = Util.sectionsFromTriplet(this.m_SetMpfSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), SetMpfSection::create);
                return this.m_SetMpfSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 14 records");
    }

    public List<SetDaeSection> setDaeSection() {
        switch (this.productHeader().smf90tid()) {
            case 16: {
                this.m_SetDaeSection = Util.sectionsFromTriplet(this.m_SetDaeSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), SetDaeSection::create);
                return this.m_SetDaeSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 16 records");
    }

    public List<SetPfkSection> setPfkSection() {
        switch (this.productHeader().smf90tid()) {
            case 17: {
                this.m_SetPfkSection = Util.sectionsFromTriplet(this.m_SetPfkSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), SetPfkSection::create);
                return this.m_SetPfkSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 17 records");
    }

    public List<SetGrsRnlSection> setGrsRnlSection() {
        switch (this.productHeader().smf90tid()) {
            case 18: {
                this.m_SetGrsRnlSection = Util.sectionsFromTriplet(this.m_SetGrsRnlSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), SetGrsRnlSection::create);
                return this.m_SetGrsRnlSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 18 records");
    }

    public List<SetAppcSection> setAppcSection() {
        switch (this.productHeader().smf90tid()) {
            case 19: {
                this.m_SetAppcSection = Util.sectionsFromTriplet(this.m_SetAppcSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), SetAppcSection::create);
                return this.m_SetAppcSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 19 records");
    }

    public List<SetAschSection> setAschSection() {
        switch (this.productHeader().smf90tid()) {
            case 20: {
                this.m_SetAschSection = Util.sectionsFromTriplet(this.m_SetAschSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), SetAschSection::create);
                return this.m_SetAschSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 20 records");
    }

    public List<SetSchSection> setSchSection() {
        switch (this.productHeader().smf90tid()) {
            case 21: {
                this.m_SetSchSection = Util.sectionsFromTriplet(this.m_SetSchSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), SetSchSection::create);
                return this.m_SetSchSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 21 records");
    }

    public List<SetCngrpSection> setCngrpSection() {
        switch (this.productHeader().smf90tid()) {
            case 22: {
                this.m_SetCngrpSection = Util.sectionsFromTriplet(this.m_SetCngrpSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), SetCngrpSection::create);
                return this.m_SetCngrpSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 22 records");
    }

    public InstallServiceDefinitionSection installServiceDefinitionSection() {
        switch (this.productHeader().smf90tid()) {
            case 23: {
                if (this.m_InstallServiceDefinitionSection != null) {
                    return this.m_InstallServiceDefinitionSection;
                }
                if (this.smf90don() != 1) {
                    throw new IllegalArgumentException("Unexpected number of service definition install sections: " + Integer.toString(this.smf90don()));
                }
                this.m_InstallServiceDefinitionSection = InstallServiceDefinitionSection.create(this.data, this.smf90dof(), this.smf90dln());
                return this.m_InstallServiceDefinitionSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 23 records");
    }

    public WlmServicePolicySection wlmServicePolicySection() {
        switch (this.productHeader().smf90tid()) {
            case 24: {
                if (this.m_WlmServicePolicySection != null) {
                    return this.m_WlmServicePolicySection;
                }
                if (this.smf90don() != 1) {
                    throw new IllegalArgumentException("Unexpected number of policy sections: " + Integer.toString(this.smf90don()));
                }
                this.m_WlmServicePolicySection = WlmServicePolicySection.create(this.data, this.smf90dof(), this.smf90dln());
                return this.m_WlmServicePolicySection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 24 records");
    }

    public static Optional<Smf90Record> buildWlmServicePolicy(Smf90Record record) {
        if (record.subType() != 24) {
            return Optional.of(record);
        }
        return ServicePolicyBuilder.buildWlmServicePolicy(record);
    }

    public static List<Smf90Record> incompleteServicePolicyRecords() {
        return ServicePolicyBuilder.incompleteServicePolicyRecords();
    }

    public static List<Smf90Record> buildWlmServicePolicy(Iterable<Smf90Record> records) {
        return ServicePolicyBuilder.buildWlmServicePolicy(records);
    }

    public ServicePolicy servicePolicy() {
        switch (this.productHeader().smf90tid()) {
            case 24: {
                if (this.m_ServicePolicy != null) {
                    return this.m_ServicePolicy;
                }
                throw new NotYetCreatedException("Call buildWlmServicePolicy() to build the Service Policy from one or more records before calling this method on the returned record.");
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 24 records");
    }

    public List<ModifyWlmSection> modifyWlmSection() {
        switch (this.productHeader().smf90tid()) {
            case 25: {
                this.m_ModifyWlmSection = Util.sectionsFromTriplet(this.m_ModifyWlmSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), ModifyWlmSection::create);
                return this.m_ModifyWlmSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 25 records");
    }

    public List<LogrecDatasetSection> logrecDatasetSection() {
        switch (this.productHeader().smf90tid()) {
            case 26: {
                this.m_LogrecDatasetSection = Util.sectionsFromTriplet(this.m_LogrecDatasetSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), LogrecDatasetSection::create);
                return this.m_LogrecDatasetSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 26 records");
    }

    public List<ArmPolicySection> armPolicySection() {
        switch (this.productHeader().smf90tid()) {
            case 27: 
            case 28: {
                this.m_ArmPolicySection = Util.sectionsFromTriplet(this.m_ArmPolicySection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), ArmPolicySection::create);
                return this.m_ArmPolicySection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 27 and 28 records");
    }

    public List<LinklstActivationSection> linklstActivationSection() {
        switch (this.productHeader().smf90tid()) {
            case 29: {
                this.m_LinklstActivationSection = Util.sectionsFromTriplet(this.m_LinklstActivationSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), LinklstActivationSection::create);
                return this.m_LinklstActivationSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 29 records");
    }

    public List<ResetCommandSection> resetCommandSection() {
        switch (this.productHeader().smf90tid()) {
            case 30: {
                this.m_ResetCommandSection = Util.sectionsFromTriplet(this.m_ResetCommandSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), ResetCommandSection::create);
                return this.m_ResetCommandSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 30 records");
    }

    public List<DynamicLpaSection> dynamicLpaSection() {
        switch (this.productHeader().smf90tid()) {
            case 31: {
                this.m_DynamicLpaSection = Util.sectionsFromTriplet(this.m_DynamicLpaSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), DynamicLpaSection::create);
                return this.m_DynamicLpaSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 31 records");
    }

    public List<Lpmea> dynamicLpaModuleEntries() {
        switch (this.productHeader().smf90tid()) {
            case 31: {
                this.m_Lpmea = Util.sectionsFromTriplet(this.m_Lpmea, this.data, () -> this.smf90dof() + this.dynamicLpaSection().get(0).smf90t31modOffset(), () -> 40, () -> this.dynamicLpaSection().get(0).smf90t31numMods(), Lpmea::create);
                return this.m_Lpmea;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 31 records");
    }

    public WlmSchedulingEnvironmentSection wlmSchedulingEnvironmentSection() {
        switch (this.productHeader().smf90tid()) {
            case 32: {
                if (this.m_WlmSchedulingEnvironmentSection != null) {
                    return this.m_WlmSchedulingEnvironmentSection;
                }
                if (this.smf90don() != 1) {
                    throw new IllegalArgumentException("Unexpected number of scheduling environment sections: " + Integer.toString(this.smf90don()));
                }
                this.m_WlmSchedulingEnvironmentSection = WlmSchedulingEnvironmentSection.create(this.data, this.smf90dof(), this.smf90dln());
                return this.m_WlmSchedulingEnvironmentSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 32 records");
    }

    public static Optional<Smf90Record> buildWlmSchedulingEnvironment(Smf90Record record) {
        if (record.subType() != 32) {
            return Optional.of(record);
        }
        return SchedulingEnvironmentBuilder.buildWlmSchedulingEnvironment(record);
    }

    public static List<Smf90Record> incompleteSchedulingEnvironmentRecords() {
        return SchedulingEnvironmentBuilder.incompleteSchedulingEnvironmentRecords();
    }

    public static List<Smf90Record> buildWlmSchedulingEnvironment(Iterable<Smf90Record> records) {
        return SchedulingEnvironmentBuilder.buildWlmSchedulingEnvironment(records);
    }

    public SchedulingEnvironment schedulingEnvironment() {
        switch (this.productHeader().smf90tid()) {
            case 32: {
                if (this.m_SchedulingEnvironment != null) {
                    return this.m_SchedulingEnvironment;
                }
                throw new NotYetCreatedException("Call buildSchedulingEnvironment() to build the Scheduling Environment from one or more records before calling this method on the returned record.");
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 32 records");
    }

    public List<SetAutoReplySection> setAutoReplySection() {
        switch (this.productHeader().smf90tid()) {
            case 33: {
                this.m_SetAutoReplySection = Util.sectionsFromTriplet(this.m_SetAutoReplySection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), SetAutoReplySection::create);
                return this.m_SetAutoReplySection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 33 records");
    }

    public List<CapacityChangeSection> capacityChangeSection() {
        switch (this.productHeader().smf90tid()) {
            case 34: {
                this.m_CapacityChangeSection = Util.sectionsFromTriplet(this.m_CapacityChangeSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), CapacityChangeSection::create);
                return this.m_CapacityChangeSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 34 records");
    }

    public List<SetLoadIeasymSection> setLoadIeasymSection() {
        switch (this.productHeader().smf90tid()) {
            case 35: {
                this.m_SetLoadIeasymSection = Util.sectionsFromTriplet(this.m_SetLoadIeasymSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), SetLoadIeasymSection::create);
                return this.m_SetLoadIeasymSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 35 records");
    }

    public List<SetConSection> setConSection() {
        switch (this.productHeader().smf90tid()) {
            case 36: {
                this.m_SetConSection = Util.sectionsFromTriplet(this.m_SetConSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), SetConSection::create);
                return this.m_SetConSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 36 records");
    }

    public List<DynamicApfSection> dynamicApfSection() {
        switch (this.productHeader().smf90tid()) {
            case 37: {
                this.m_DynamicApfSection = Util.sectionsFromTriplet(this.m_DynamicApfSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), DynamicApfSection::create);
                return this.m_DynamicApfSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 37 records");
    }

    public List<IefopzConfigurationSection> iefopzConfigurationSection() {
        switch (this.productHeader().smf90tid()) {
            case 38: {
                this.m_IefopzConfigurationSection = Util.sectionsFromTriplet(this.m_IefopzConfigurationSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), IefopzConfigurationSection::create);
                return this.m_IefopzConfigurationSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 38 records");
    }

    public List<IefopzOldNewSection> iefopzOldNewSection() {
        switch (this.productHeader().smf90tid()) {
            case 38: {
                this.m_IefopzOldNewSection = Util.sectionsFromTriplet(this.m_IefopzOldNewSection, this.data, () -> this.iefopzConfigurationSection().get(0).smf90t38OldnewOffset(), () -> this.iefopzConfigurationSection().get(0).smf90t38OldnewLen(), () -> this.iefopzConfigurationSection().get(0).smf90t38NumOldnew(), IefopzOldNewSection::create);
                return this.m_IefopzOldNewSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 38 records");
    }

    public List<IefopzDDJobnameSection> iefopzDDJobnameSection() {
        switch (this.productHeader().smf90tid()) {
            case 38: {
                this.m_IefopzDDJobnameSection = Util.sectionsFromTriplet(this.m_IefopzDDJobnameSection, this.data, () -> this.iefopzConfigurationSection().get(0).smf90t38DDJobnameOffset(), () -> this.iefopzConfigurationSection().get(0).smf90t38DDJobnameLen(), () -> this.iefopzConfigurationSection().get(0).smf90t38NumDDJobname(), IefopzDDJobnameSection::create);
                return this.m_IefopzDDJobnameSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 38 records");
    }

    public List<SetSmfLimSection> setSmfLimSection() {
        switch (this.productHeader().smf90tid()) {
            case 39: {
                this.m_SetSmfLimSection = Util.sectionsFromTriplet(this.m_SetSmfLimSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), SetSmfLimSection::create);
                return this.m_SetSmfLimSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 39 records");
    }

    public List<SystemRecoveryBoostSection> systemRecoveryBoostSection() {
        switch (this.productHeader().smf90tid()) {
            case 40: {
                this.m_SystemRecoveryBoostSection = Util.sectionsFromTriplet(this.m_SystemRecoveryBoostSection, this.data, () -> this.smf90dof(), () -> this.smf90dln(), () -> this.smf90don(), SystemRecoveryBoostSection::create);
                return this.m_SystemRecoveryBoostSection;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 40 records");
    }

    public CvtlsoChange cvtlsoChangeSection() {
        switch (this.productHeader().smf90tid()) {
            case 41: {
                int length = this.smf90dln();
                int offset = this.smf90dof();
                this.m_CvtlsoChange = CvtlsoChange.create(this.data, offset, length);
                return this.m_CvtlsoChange;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 41 records");
    }

    public ValidatedBootHeader validatedBootHeader() {
        if (this.m_ValidatedBootHeader != null) {
            return this.m_ValidatedBootHeader;
        }
        switch (this.productHeader().smf90tid()) {
            case 42: {
                int length = 56;
                int offset = this.smf90dof();
                this.m_ValidatedBootHeader = ValidatedBootHeader.create(this.data, offset, length);
                return this.m_ValidatedBootHeader;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 42 records");
    }

    public List<ValidatedBootAuditEntry> validatedBootAuditEntries() {
        switch (this.productHeader().smf90tid()) {
            case 42: {
                this.m_ValidatedBootAuditEntry = Util.sectionsFromTriplet(this.m_ValidatedBootAuditEntry, this.data, this.validatedBootHeader().smf90t42AuditOffTriplet(), ValidatedBootAuditEntry::create);
                return this.m_ValidatedBootAuditEntry;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 42 records");
    }

    public List<ValidatedBootCX> validatedBootCX() {
        switch (this.productHeader().smf90tid()) {
            case 42: {
                this.m_ValidatedBootCX = Util.sectionsFromTriplet(this.m_ValidatedBootCX, this.data, this.validatedBootHeader().smf90t42CxOffTriplet(), ValidatedBootCX::create);
                return this.m_ValidatedBootCX;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 42 records");
    }

    public List<ValidatedBootBadCX> validatedBootBadCX() {
        switch (this.productHeader().smf90tid()) {
            case 42: {
                this.m_ValidatedBootBadCX = Util.sectionsFromTriplet(this.m_ValidatedBootBadCX, this.data, this.validatedBootHeader().smf90t42BadCxOffTriplet(), ValidatedBootBadCX::create);
                return this.m_ValidatedBootBadCX;
            }
        }
        throw new NotAvailableException("This method is only supported for subtype 42 records");
    }

    void set_m_SchedulingEnvironment(SchedulingEnvironment m_SchedulingEnvironment) {
        this.m_SchedulingEnvironment = m_SchedulingEnvironment;
    }

    void set_m_ServicePolicy(ServicePolicy m_ServicePolicy) {
        this.m_ServicePolicy = m_ServicePolicy;
    }

    static enum Field {
        smf90len(0, 2),
        smf90seg(2, 2),
        smf90flg(4, 1),
        smf90rty(5, 1),
        smf90tme(6, 4),
        smf90dte(10, 4),
        smf90sid(14, 4),
        smf90pof(20, 4),
        smf90pln(24, 2),
        smf90pon(26, 2),
        smf90dof(28, 4),
        smf90dln(32, 2),
        smf90don(34, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

