/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf90;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;

public final class SmfSwitchSection
extends SmfData {
    private SmfSwitchSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf90swo() {
        return Util.ConvertEbcdic(this.data, 0, 10);
    }

    public String smf90swn() {
        return Util.ConvertEbcdic(this.data, 10, 10);
    }

    public LocalTime smf90it() {
        return Util.Binary4x100STime(this.data, 20);
    }

    public long smf90itRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public LocalDate smf90id() {
        return Util.SMFDate(this.data, 24);
    }

    public int smf90idRawValue() {
        return Util.ConvertPacked4(this.data, 24);
    }

    public String smf90sod() {
        return Util.ConvertEbcdic(this.data, 28, 44);
    }

    public String smf90snd() {
        return Util.ConvertEbcdic(this.data, 72, 44);
    }

    public static SmfSwitchSection create(byte[] Data2, int offset, int length) {
        return new SmfSwitchSection(Data2, offset, length);
    }

    static enum Field {
        smf90swo(0, 10),
        smf90swn(10, 10),
        smf90it(20, 4),
        smf90id(24, 4),
        smf90sod(28, 44),
        smf90snd(72, 44);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

