/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf90;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Triplet;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf90.ValidatedBootMode;
import java.time.Duration;
import java.time.ZoneOffset;

public final class ValidatedBootHeader
extends SmfData {
    public static final int SMF90T42_NotFirst = 128;
    public static final int SMF90T42_NotLast = 64;
    public static final int SMF90T42_F_VBMode = 192;

    private ValidatedBootHeader(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smf90t42Cont() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public boolean smf90t42NotFirst() {
        return Util.ConvertFlag(this.data, this.smf90t42Cont(), 128);
    }

    public boolean smf90t42NotLast() {
        return Util.ConvertFlag(this.data, this.smf90t42Cont(), 64);
    }

    public int smf90t42Flags() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public ValidatedBootMode validatedBootMode() {
        return ValidatedBootMode.from(Util.ConvertUnsignedBinary1(this.data, 1) & 0xC0);
    }

    public int smf90t42Part() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public long smf90t42NumFailures() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long smf90t42NumFailuresNoDSNE() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public int smf90t42AuditOff() {
        return Util.ConvertSignedBinary4(this.data, 16);
    }

    Triplet smf90t42AuditOffTriplet() {
        return Triplet.get422Triplet(this.data, 16);
    }

    public int smf90t42AuditLen() {
        return Util.ConvertUnsignedBinary2(this.data, 20);
    }

    public int smf90t42AuditNum() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int smf90t42CxOff() {
        return Util.ConvertSignedBinary4(this.data, 24);
    }

    Triplet smf90t42CxOffTriplet() {
        return Triplet.get422Triplet(this.data, 24);
    }

    public int smf90t42CxLen() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int smf90t42CxNum() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public int smf90t42BadCxOff() {
        return Util.ConvertSignedBinary4(this.data, 32);
    }

    Triplet smf90t42BadCxOffTriplet() {
        return Triplet.get422Triplet(this.data, 32);
    }

    public int smf90t42BadCxLen() {
        return Util.ConvertUnsignedBinary2(this.data, 36);
    }

    public int smf90t42BadCxNum() {
        return Util.ConvertUnsignedBinary2(this.data, 38);
    }

    public ZoneOffset smf90t42Tzo() {
        return Util.Binary8_STCK_GMT_Offset(this.data, 40);
    }

    public long smf90t42TzoRawValue() {
        return Util.ConvertSignedBinary8(this.data, 40);
    }

    public Duration smf90t42LeapSeconds() {
        return Util.Binary8StckInterval(this.data, 48);
    }

    public double smf90t42LeapSecondsSeconds() {
        return Util.ToSeconds(this.smf90t42LeapSeconds());
    }

    public long smf90t42LeapSecondsRawValue() {
        return Util.ConvertSignedBinary8(this.data, 48);
    }

    public static ValidatedBootHeader create(byte[] Data2, int offset, int length) {
        return new ValidatedBootHeader(Data2, offset, length);
    }

    static enum Field {
        smf90t42Cont(0, 1),
        smf90t42Flags(1, 1),
        smf90t42Part(2, 2),
        smf90t42NumFailures(8, 4),
        smf90t42NumFailuresNoDSNE(12, 4),
        smf90t42AuditOff(16, 4),
        smf90t42AuditLen(20, 2),
        smf90t42AuditNum(22, 2),
        smf90t42CxOff(24, 4),
        smf90t42CxLen(28, 2),
        smf90t42CxNum(30, 2),
        smf90t42BadCxOff(32, 4),
        smf90t42BadCxLen(36, 2),
        smf90t42BadCxNum(38, 2),
        smf90t42Tzo(40, 8),
        smf90t42LeapSeconds(48, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

