/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;

public final class CallCountsEntry
extends SmfData {
    private CallCountsEntry(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long smf92vcc() {
        return Util.ConvertUnsignedBinary8(this.data, 0);
    }

    public BigInteger smf92vccAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 0);
    }

    public long smf92vcx() {
        return Util.ConvertUnsignedBinary8(this.data, 8);
    }

    public BigInteger smf92vcxAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 8);
    }

    public long smf92vcr() {
        return Util.ConvertUnsignedBinary8(this.data, 16);
    }

    public BigInteger smf92vcrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 16);
    }

    public long smf92vcrx() {
        return Util.ConvertUnsignedBinary8(this.data, 24);
    }

    public BigInteger smf92vcrxAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public Duration smf92vct() {
        return Util.Binary4US(this.data, 32);
    }

    public double smf92vctSeconds() {
        return Util.ToSeconds(this.smf92vct());
    }

    public long smf92vctRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public Duration smf92vcrt() {
        return Util.Binary4US(this.data, 36);
    }

    public double smf92vcrtSeconds() {
        return Util.ToSeconds(this.smf92vcrt());
    }

    public long smf92vcrtRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public String smf92vcn() {
        return Util.ConvertEbcdic(this.data, 40, 52);
    }

    public static CallCountsEntry create(byte[] Data2, int offset, int length) {
        return new CallCountsEntry(Data2, offset, length);
    }

    static enum Field {
        smf92vcc(0, 8),
        smf92vcx(8, 8),
        smf92vcr(16, 8),
        smf92vcrx(24, 8),
        smf92vct(32, 4),
        smf92vcrt(36, 4),
        smf92vcn(40, 52);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

