/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf92.IoCircumstanceEntry;
import java.math.BigInteger;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DiskIOStatistics
extends SmfData {
    private List<IoCircumstanceEntry> _ioCircumstanceEntry = null;
    public static final int SMF92ST5_LEN = 140;

    private DiskIOStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ZonedDateTime smf92iot() {
        return Util.Binary16StckeTime(this.data, 0);
    }

    public BigInteger smf92iotRawValue() {
        return Util.ConvertBigInteger(this.data, 0, 16);
    }

    public long smf92iord() {
        return Util.ConvertUnsignedBinary8(this.data, 16);
    }

    public BigInteger smf92iordAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 16);
    }

    public long smf92iowr() {
        return Util.ConvertUnsignedBinary8(this.data, 24);
    }

    public BigInteger smf92iowrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public long smf92iordb() {
        return Util.ConvertUnsignedBinary8(this.data, 32);
    }

    public BigInteger smf92iordbAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 32);
    }

    public long smf92iowrb() {
        return Util.ConvertUnsignedBinary8(this.data, 40);
    }

    public BigInteger smf92iowrbAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 40);
    }

    public Duration smf92liowt() {
        return Util.Binary8USSeconds(this.data, 48);
    }

    public double smf92liowtSeconds() {
        return Util.ToSeconds(this.smf92liowt());
    }

    public BigInteger smf92liowtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 48);
    }

    public long smf92iowtt() {
        return Util.ConvertUnsignedBinary8(this.data, 56);
    }

    public BigInteger smf92iowttAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    public long smf92iouc() {
        return Util.ConvertUnsignedBinary8(this.data, 64);
    }

    public BigInteger smf92ioucAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    public long smf92ioucm() {
        return Util.ConvertUnsignedBinary8(this.data, 72);
    }

    public BigInteger smf92ioucmAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 72);
    }

    public long smf92ioucc() {
        return Util.ConvertUnsignedBinary8(this.data, 80);
    }

    public BigInteger smf92iouccAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public long smf92iomc() {
        return Util.ConvertUnsignedBinary8(this.data, 88);
    }

    public BigInteger smf92iomcAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 88);
    }

    public long smf92iomcm() {
        return Util.ConvertUnsignedBinary8(this.data, 96);
    }

    public BigInteger smf92iomcmAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 96);
    }

    public long smf92iomcc() {
        return Util.ConvertUnsignedBinary8(this.data, 104);
    }

    public BigInteger smf92iomccAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 104);
    }

    public long smf92iolc() {
        return Util.ConvertUnsignedBinary8(this.data, 112);
    }

    public BigInteger smf92iolcAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 112);
    }

    public long smf92iolcm() {
        return Util.ConvertUnsignedBinary8(this.data, 120);
    }

    public BigInteger smf92iolcmAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 120);
    }

    public long smf92iolcc() {
        return Util.ConvertUnsignedBinary8(this.data, 128);
    }

    public BigInteger smf92iolccAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 128);
    }

    public int smf92iocct() {
        return Util.ConvertUnsignedBinary2(this.data, 136);
    }

    public int smf92ioccl() {
        return Util.ConvertUnsignedBinary2(this.data, 138);
    }

    public List<IoCircumstanceEntry> ioCircumstanceEntries() {
        if (this._ioCircumstanceEntry == null) {
            ArrayList<IoCircumstanceEntry> list = new ArrayList<IoCircumstanceEntry>(this.smf92iocct());
            for (int i = 0; i < this.smf92iocct(); ++i) {
                list.add(IoCircumstanceEntry.create(this.data, 140 + i * this.smf92ioccl(), this.smf92ioccl()));
            }
            this._ioCircumstanceEntry = Collections.unmodifiableList(list);
        }
        return this._ioCircumstanceEntry;
    }

    public static DiskIOStatistics create(byte[] Data2, int offset, int length) {
        return new DiskIOStatistics(Data2, offset, length);
    }

    static enum Field {
        smf92iot(0, 16),
        smf92iord(16, 8),
        smf92iowr(24, 8),
        smf92iordb(32, 8),
        smf92iowrb(40, 8),
        smf92liowt(48, 8),
        smf92iowtt(56, 8),
        smf92iouc(64, 8),
        smf92ioucm(72, 8),
        smf92ioucc(80, 8),
        smf92iomc(88, 8),
        smf92iomcm(96, 8),
        smf92iomcc(104, 8),
        smf92iolc(112, 8),
        smf92iolcm(120, 8),
        smf92iolcc(128, 8),
        smf92iocct(136, 2),
        smf92ioccl(138, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

