/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf92.FileType;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class FileOpen
extends SmfData {
    public static final int SMF92ONF = 128;
    public static final int SMF92ONS = 64;
    public static final int SMF92OCS = 32;

    private FileOpen(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ZonedDateTime smf92oto() {
        return Util.Binary8xStckTime(this.data, 0);
    }

    public BigInteger smf92otoRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 0);
    }

    public FileType smf92oty() {
        return FileType.fromValue(this.smf92otyRawValue());
    }

    public int smf92otyRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 8);
    }

    public int smf92ofg() {
        return Util.ConvertUnsignedBinary1(this.data, 9);
    }

    public boolean smf92onf() {
        return Util.ConvertFlag(this.data, this.smf92ofg(), 128);
    }

    public boolean smf92ons() {
        return Util.ConvertFlag(this.data, this.smf92ofg(), 64);
    }

    public boolean smf92ocs() {
        return Util.ConvertFlag(this.data, this.smf92ofg(), 32);
    }

    public long smf92otk() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long smf92oin() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long smf92odn() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public static FileOpen create(byte[] Data2, int offset, int length) {
        return new FileOpen(Data2, offset, length);
    }

    static enum Field {
        smf92oto(0, 8),
        smf92oty(8, 1),
        smf92ofg(9, 1),
        smf92otk(12, 4),
        smf92oin(16, 4),
        smf92odn(20, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

