/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf92.FileSystemType;
import com.blackhillsoftware.smf.smf92.MntEntFsMode;
import com.blackhillsoftware.smf.smf92.MountParmOption;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class FileSystemMigration
extends SmfData {
    private byte[] parentData;
    public static final int SMF92GLU = 128;
    public static final int SMF92GNU = 64;
    public static final int SMF92GSN = 16;

    private FileSystemMigration(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
        this.parentData = Data2;
    }

    public ZonedDateTime smf92gtm() {
        return Util.Binary8xStckTime(this.data, 0);
    }

    public BigInteger smf92gtmRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 0);
    }

    public int smf92gmo() {
        return Util.ConvertSignedBinary4(this.data, 8);
    }

    public MountParmOption mountParmOptionSection() {
        return MountParmOption.create(this.parentData, this.smf92gmo(), MountParmOption.smf92mol(this.parentData, this.smf92gmo()) + MountParmOption.Field.smf92mol.length());
    }

    public String smf92mon() {
        return this.mountParmOptionSection().smf92mon();
    }

    public FileSystemType smf92gft() {
        return FileSystemType.fromValue(this.smf92gftRawValue());
    }

    public long smf92gftRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public MntEntFsMode smf92gfm() {
        return MntEntFsMode.create(this.data, Field.smf92gfm.offset, Field.smf92gfm.length);
    }

    public long smf92gfmRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long smf92gdn() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public String smf92gdd() {
        return Util.ConvertEbcdic(this.data, 24, 8);
    }

    public String smf92gtn() {
        return Util.ConvertEbcdic(this.data, 32, 8);
    }

    public String smf92gfn() {
        return Util.ConvertEbcdic(this.data, 40, 44);
    }

    public String smf92gon() {
        return Util.ConvertEbcdic(this.data, 84, 44);
    }

    public long smf92gbl() {
        return Util.ConvertUnsignedBinary4(this.data, 128);
    }

    public long smf92gst() {
        return Util.ConvertUnsignedBinary8(this.data, 132);
    }

    public BigInteger smf92gstAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 132);
    }

    public long smf92gsu() {
        return Util.ConvertUnsignedBinary8(this.data, 140);
    }

    public BigInteger smf92gsuAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 140);
    }

    public int smf92gfg() {
        return Util.ConvertUnsignedBinary1(this.data, 148);
    }

    public int smf92gf2() {
        return Util.ConvertUnsignedBinary1(this.data, 149);
    }

    public boolean smf92glu() {
        return Util.ConvertFlag(this.data, this.smf92gf2(), 128);
    }

    public boolean smf92gnu() {
        return Util.ConvertFlag(this.data, this.smf92gf2(), 64);
    }

    public boolean smf92gsn() {
        return Util.ConvertFlag(this.data, this.smf92gf2(), 16);
    }

    public static FileSystemMigration create(byte[] Data2, int offset, int length) {
        return new FileSystemMigration(Data2, offset, length);
    }

    static enum Field {
        smf92gtm(0, 8),
        smf92gmo(8, 4),
        smf92gft(12, 4),
        smf92gfm(16, 4),
        smf92gdn(20, 4),
        smf92gdd(24, 8),
        smf92gtn(32, 8),
        smf92gfn(40, 44),
        smf92gon(84, 44),
        smf92gbl(128, 4),
        smf92gst(132, 8),
        smf92gsu(140, 8),
        smf92gfg(148, 1),
        smf92gf2(149, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

