/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf92.FileSystemType;
import com.blackhillsoftware.smf.smf92.MntEntFsMode;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class FileSystemMove
extends SmfData {
    public static final int SMF92VUI = 128;
    public static final int SMF92VRI = 64;
    public static final int SMF92VOL = 128;
    public static final int SMF92VON = 64;
    public static final int SMF92VOD = 32;
    public static final int SMF92VOS = 16;
    public static final int SMF92VNL = 128;
    public static final int SMF92VNN = 64;
    public static final int SMF92VND = 32;
    public static final int SMF92VNS = 16;

    private FileSystemMove(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ZonedDateTime smf92vtv() {
        return Util.Binary8xStckTime(this.data, 0);
    }

    public BigInteger smf92vtvRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 0);
    }

    public ZonedDateTime smf92vtm() {
        return Util.Binary8xStckTime(this.data, 8);
    }

    public BigInteger smf92vtmRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 8);
    }

    public FileSystemType smf92vft() {
        return FileSystemType.fromValue(this.smf92vftRawValue());
    }

    public long smf92vftRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public MntEntFsMode smf92vfm() {
        return MntEntFsMode.create(this.data, Field.smf92vfm.offset, Field.smf92vfm.length);
    }

    public long smf92vfmRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long smf92vdn() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public String smf92vdd() {
        return Util.ConvertEbcdic(this.data, 28, 8);
    }

    public String smf92vtn() {
        return Util.ConvertEbcdic(this.data, 36, 8);
    }

    public String smf92vnm() {
        return Util.ConvertEbcdic(this.data, 44, 44);
    }

    public long smf92vbl() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long smf92vst() {
        return Util.ConvertUnsignedBinary8(this.data, 92);
    }

    public BigInteger smf92vstAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 92);
    }

    public long smf92vsu() {
        return Util.ConvertUnsignedBinary8(this.data, 100);
    }

    public BigInteger smf92vsuAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 100);
    }

    public long smf92vsr() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public long smf92vsw() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public long smf92vdi() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public long smf92vir() {
        return Util.ConvertUnsignedBinary4(this.data, 120);
    }

    public long smf92viw() {
        return Util.ConvertUnsignedBinary4(this.data, 124);
    }

    public long smf92vbr() {
        return Util.ConvertUnsignedBinary8(this.data, 128);
    }

    public BigInteger smf92vbrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 128);
    }

    public long smf92vbw() {
        return Util.ConvertUnsignedBinary8(this.data, 136);
    }

    public BigInteger smf92vbwAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 136);
    }

    public int smf92vfg() {
        return Util.ConvertUnsignedBinary1(this.data, 144);
    }

    public boolean smf92vui() {
        return Util.ConvertFlag(this.data, this.smf92vfg(), 128);
    }

    public boolean smf92vri() {
        return Util.ConvertFlag(this.data, this.smf92vfg(), 64);
    }

    public int smf92vof() {
        return Util.ConvertUnsignedBinary1(this.data, 145);
    }

    public boolean smf92vol() {
        return Util.ConvertFlag(this.data, this.smf92vof(), 128);
    }

    public boolean smf92von() {
        return Util.ConvertFlag(this.data, this.smf92vof(), 64);
    }

    public boolean smf92vod() {
        return Util.ConvertFlag(this.data, this.smf92vof(), 32);
    }

    public boolean smf92vos() {
        return Util.ConvertFlag(this.data, this.smf92vof(), 16);
    }

    public int smf92vnf() {
        return Util.ConvertUnsignedBinary1(this.data, 146);
    }

    public boolean smf92vnl() {
        return Util.ConvertFlag(this.data, this.smf92vnf(), 128);
    }

    public boolean smf92vnn() {
        return Util.ConvertFlag(this.data, this.smf92vnf(), 64);
    }

    public boolean smf92vnd() {
        return Util.ConvertFlag(this.data, this.smf92vnf(), 32);
    }

    public boolean smf92vns() {
        return Util.ConvertFlag(this.data, this.smf92vnf(), 16);
    }

    public static FileSystemMove create(byte[] Data2, int offset, int length) {
        return new FileSystemMove(Data2, offset, length);
    }

    static enum Field {
        smf92vtv(0, 8),
        smf92vtm(8, 8),
        smf92vft(16, 4),
        smf92vfm(20, 4),
        smf92vdn(24, 4),
        smf92vdd(28, 8),
        smf92vtn(36, 8),
        smf92vnm(44, 44),
        smf92vbl(88, 4),
        smf92vst(92, 8),
        smf92vsu(100, 8),
        smf92vsr(108, 4),
        smf92vsw(112, 4),
        smf92vdi(116, 4),
        smf92vir(120, 4),
        smf92viw(124, 4),
        smf92vbr(128, 8),
        smf92vbw(136, 8),
        smf92vfg(144, 1),
        smf92vof(145, 1),
        smf92vnf(146, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

