/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf92.FileSystemType;
import com.blackhillsoftware.smf.smf92.MntEntFsMode;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class FileSystemSuspend
extends SmfData {
    public static final int SMF92SLU = 128;
    public static final int SMF92SNU = 64;
    public static final int SMF92SDO = 32;
    public static final int SMF92SSN = 16;

    private FileSystemSuspend(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ZonedDateTime smf92sts() {
        return Util.Binary8xStckTime(this.data, 0);
    }

    public BigInteger smf92stsRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 0);
    }

    public FileSystemType smf92sft() {
        return FileSystemType.fromValue(this.smf92sftRawValue());
    }

    public long smf92sftRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public MntEntFsMode smf92sfm() {
        return MntEntFsMode.create(this.data, Field.smf92sfm.offset, Field.smf92sfm.length);
    }

    public long smf92sfmRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long smf92sdn() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public String smf92sdd() {
        return Util.ConvertEbcdic(this.data, 20, 8);
    }

    public String smf92stn() {
        return Util.ConvertEbcdic(this.data, 28, 8);
    }

    public String smf92sfn() {
        return Util.ConvertEbcdic(this.data, 36, 44);
    }

    public int smf92sfg() {
        return Util.ConvertUnsignedBinary1(this.data, 80);
    }

    public boolean smf92slu() {
        return Util.ConvertFlag(this.data, this.smf92sfg(), 128);
    }

    public boolean smf92snu() {
        return Util.ConvertFlag(this.data, this.smf92sfg(), 64);
    }

    public boolean smf92sdo() {
        return Util.ConvertFlag(this.data, this.smf92sfg(), 32);
    }

    public boolean smf92ssn() {
        return Util.ConvertFlag(this.data, this.smf92sfg(), 16);
    }

    public static FileSystemSuspend create(byte[] Data2, int offset, int length) {
        return new FileSystemSuspend(Data2, offset, length);
    }

    static enum Field {
        smf92sts(0, 8),
        smf92sft(8, 4),
        smf92sfm(12, 4),
        smf92sdn(16, 4),
        smf92sdd(20, 8),
        smf92stn(28, 8),
        smf92sfn(36, 44),
        smf92sfg(80, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

