/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf92.FileSystemEventType;
import java.math.BigInteger;
import java.time.Duration;
import java.time.ZonedDateTime;

public final class FilesystemEvent
extends SmfData {
    private FilesystemEvent(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf92fsn() {
        return Util.ConvertEbcdic(this.data, 0, 44);
    }

    public String smf92vol() {
        return Util.ConvertEbcdic(this.data, 44, 6);
    }

    public long smf92cchh() {
        return Util.ConvertUnsignedBinary4(this.data, 50);
    }

    public FileSystemEventType smf92event() {
        return FileSystemEventType.fromValue(this.smf92eventRawValue());
    }

    public int smf92eventRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 54);
    }

    public long smf92siz() {
        return Util.ConvertUnsignedBinary8(this.data, 56);
    }

    public BigInteger smf92sizAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    public ZonedDateTime smf92t50() {
        return Util.Binary16StckeTime(this.data, 64);
    }

    public BigInteger smf92t50RawValue() {
        return Util.ConvertBigInteger(this.data, 64, 16);
    }

    public long smf92code() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long smf92rsn() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public String smf92ovs() {
        return Util.ConvertEbcdic(this.data, 88, 6);
    }

    public Duration smf92och() {
        return Util.Binary4MS(this.data, 94);
    }

    public double smf92ochSeconds() {
        return Util.ToSeconds(this.smf92och());
    }

    public long smf92ochRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 94);
    }

    public Duration smf92lrt() {
        return Util.Binary4MS(this.data, 98);
    }

    public double smf92lrtSeconds() {
        return Util.ToSeconds(this.smf92lrt());
    }

    public long smf92lrtRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 98);
    }

    public long smf92lrp() {
        return Util.ConvertUnsignedBinary4(this.data, 102);
    }

    public long smf92lrr() {
        return Util.ConvertUnsignedBinary4(this.data, 106);
    }

    public long smf92lrd() {
        return Util.ConvertUnsignedBinary4(this.data, 110);
    }

    public long smf92lre() {
        return Util.ConvertUnsignedBinary4(this.data, 114);
    }

    public long smf92lrf() {
        return Util.ConvertUnsignedBinary4(this.data, 118);
    }

    public long smf92lrn() {
        return Util.ConvertUnsignedBinary4(this.data, 122);
    }

    public String smf92sys() {
        return Util.ConvertEbcdic(this.data, 126, 8);
    }

    public static FilesystemEvent create(byte[] Data2, int offset, int length) {
        return new FilesystemEvent(Data2, offset, length);
    }

    static enum Field {
        smf92fsn(0, 44),
        smf92vol(44, 6),
        smf92cchh(50, 4),
        smf92event(54, 1),
        smf92siz(56, 8),
        smf92t50(64, 16),
        smf92code(80, 4),
        smf92rsn(84, 4),
        smf92ovs(88, 6),
        smf92och(94, 4),
        smf92lrt(98, 4),
        smf92lrp(102, 4),
        smf92lrr(106, 4),
        smf92lrd(110, 4),
        smf92lre(114, 4),
        smf92lrf(118, 4),
        smf92lrn(122, 4),
        smf92sys(126, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

