/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf92.CallCounts;
import com.blackhillsoftware.smf.smf92.DiskIOStatistics;
import com.blackhillsoftware.smf.smf92.FileAccess;
import com.blackhillsoftware.smf.smf92.FileClose;
import com.blackhillsoftware.smf.smf92.FileDeleteRename;
import com.blackhillsoftware.smf.smf92.FileOpen;
import com.blackhillsoftware.smf.smf92.FileSecurityAttrChange;
import com.blackhillsoftware.smf.smf92.FileSystemMigration;
import com.blackhillsoftware.smf.smf92.FileSystemMount;
import com.blackhillsoftware.smf.smf92.FileSystemMove;
import com.blackhillsoftware.smf.smf92.FileSystemResume;
import com.blackhillsoftware.smf.smf92.FileSystemSuspend;
import com.blackhillsoftware.smf.smf92.FileSystemUnmountRemount;
import com.blackhillsoftware.smf.smf92.FilesystemEvent;
import com.blackhillsoftware.smf.smf92.IdentificationSection;
import com.blackhillsoftware.smf.smf92.LockAndSleepStatistics;
import com.blackhillsoftware.smf.smf92.MMap;
import com.blackhillsoftware.smf.smf92.MUnMap;
import com.blackhillsoftware.smf.smf92.MemoryUsage;
import com.blackhillsoftware.smf.smf92.MetadataCacheStatistics;
import com.blackhillsoftware.smf.smf92.PerFilesystemUsageInformation;
import com.blackhillsoftware.smf.smf92.SubsystemSection;
import com.blackhillsoftware.smf.smf92.TokenManagerInformation;
import com.blackhillsoftware.smf.smf92.TransmitReceiveStatistics;
import com.blackhillsoftware.smf.smf92.UserCacheStatistics;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Smf92Record
extends SmfRecord {
    private boolean zfs = false;
    private List<SubsystemSection> m_SubsystemSections = null;
    private List<IdentificationSection> m_IdentificationSections = null;
    private List<FileSystemMount> m_FileSystemMount = null;
    private List<FileSystemSuspend> m_FileSystemSuspend = null;
    private List<FileSystemResume> m_FileSystemResume = null;
    private List<FileSystemUnmountRemount> m_FileSystemUnmountRemount = null;
    private List<FileSystemMove> m_FileSystemMove = null;
    private List<FileSystemMigration> m_FileSystemMigration = null;
    private List<FileOpen> m_FileOpen = null;
    private List<FileClose> m_FileClose = null;
    private List<MMap> m_MMap = null;
    private List<MUnMap> m_MUnMap = null;
    private List<FileDeleteRename> m_FileDeleteRename = null;
    private List<FileSecurityAttrChange> m_FileSecurityAttrChange = null;
    private List<FileAccess> m_FileAccess = null;
    private List<FilesystemEvent> m_FilesystemEvent = null;
    private List<CallCounts> m_CallCounts = null;
    private List<UserCacheStatistics> m_UserCacheStatistics = null;
    private List<MetadataCacheStatistics> m_MetadataCacheStatistics = null;
    private List<LockAndSleepStatistics> m_LockAndSleepStatistics = null;
    private List<DiskIOStatistics> m_DiskIOStatistics = null;
    private List<TokenManagerInformation> m_TokenManagerInformation = null;
    private List<MemoryUsage> m_MemoryUsage = null;
    private List<TransmitReceiveStatistics> m_TransmitReceiveStatistics = null;
    private List<PerFilesystemUsageInformation> m_PerFilesystemUsageInformation = null;
    public static final int SMF92SSF = 128;
    public static final int SMF92SBT = 64;
    public static final String SMF92_VERSION02 = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(61682).array(), 2, 2);
    public static final String SMF92_VERSION01 = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(61681).array(), 2, 2);
    public static final String SMF92_VERSION = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(61682).array(), 2, 2);
    public static final int SMF92_MOUNT = 1;
    public static final int SMF92_SUSPEND = 2;
    public static final int SMF92_RESUME = 4;
    public static final int SMF92_UNMOUNT = 5;
    public static final int SMF92_REMOUNT = 6;
    public static final int SMF92_MOVE = 7;
    public static final int SMF92_OPEN = 10;
    public static final int SMF92_CLOSE = 11;
    public static final int SMF92_MMAP = 12;
    public static final int SMF92_MUNMAP = 13;
    public static final int SMF92_DELETE = 14;
    public static final int SMF92_EXTSEC = 15;
    public static final int SMF92_CLSSOCCHARSPEC = 16;
    public static final int SMF92_FILEACC = 17;
    public static final int SMF92_MIGRATION = 8;

    public Smf92Record(byte[] data) {
        super(data);
        if (this.recordType() != 92) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
        this.zfs = this.smf92stp() >= 50;
    }

    public Smf92Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 92) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
        this.zfs = this.smf92stp() >= 50;
    }

    public static Smf92Record from(SmfRecord record) {
        return new Smf92Record(record);
    }

    public static Smf92Record from(byte[] data) {
        return new Smf92Record(data);
    }

    public SubsystemSection subsystemSection() {
        return this.subsystemSections().get(0);
    }

    public List<SubsystemSection> subsystemSections() {
        this.m_SubsystemSections = Util.sectionsFromTriplet(this.m_SubsystemSections, this.data, () -> this.smf92sof(), () -> this.smf92sln(), () -> this.smf92son(), SubsystemSection::create);
        return this.m_SubsystemSections;
    }

    public IdentificationSection identificationSection() {
        return this.identificationSections().get(0);
    }

    public List<IdentificationSection> identificationSections() {
        if (this.m_IdentificationSections != null) {
            return this.m_IdentificationSections;
        }
        int count = this.smf92ion();
        if (count == 0) {
            return Collections.emptyList();
        }
        int length = this.smf92iln();
        int offset = this.smf92iof();
        ArrayList<IdentificationSection> result = new ArrayList<IdentificationSection>(count);
        for (int i = 0; i < count; ++i) {
            result.add(IdentificationSection.create(this.data, offset + i * length, length, this.zfs));
        }
        this.m_IdentificationSections = Collections.unmodifiableList(result);
        return this.m_IdentificationSections;
    }

    public List<FileSystemMount> fileSystemMounts() {
        if (this.m_FileSystemMount != null) {
            return this.m_FileSystemMount;
        }
        if (this.smf92stp() != 1) {
            return Collections.emptyList();
        }
        this.m_FileSystemMount = Util.sectionsFromTriplet(this.m_FileSystemMount, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), FileSystemMount::create);
        return this.m_FileSystemMount;
    }

    public List<FileSystemSuspend> fileSystemSuspends() {
        if (this.m_FileSystemSuspend != null) {
            return this.m_FileSystemSuspend;
        }
        if (this.smf92stp() != 2) {
            return Collections.emptyList();
        }
        this.m_FileSystemSuspend = Util.sectionsFromTriplet(this.m_FileSystemSuspend, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), FileSystemSuspend::create);
        return this.m_FileSystemSuspend;
    }

    public List<FileSystemResume> fileSystemResumes() {
        if (this.m_FileSystemResume != null) {
            return this.m_FileSystemResume;
        }
        if (this.smf92stp() != 4) {
            return Collections.emptyList();
        }
        this.m_FileSystemResume = Util.sectionsFromTriplet(this.m_FileSystemResume, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), FileSystemResume::create);
        return this.m_FileSystemResume;
    }

    public List<FileSystemUnmountRemount> fileSystemUnmountRemounts() {
        if (this.m_FileSystemUnmountRemount != null) {
            return this.m_FileSystemUnmountRemount;
        }
        if (this.smf92stp() != 5 && this.smf92stp() != 6) {
            return Collections.emptyList();
        }
        this.m_FileSystemUnmountRemount = Util.sectionsFromTriplet(this.m_FileSystemUnmountRemount, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), FileSystemUnmountRemount::create);
        return this.m_FileSystemUnmountRemount;
    }

    public List<FileSystemMove> fileSystemMoves() {
        if (this.m_FileSystemMove != null) {
            return this.m_FileSystemMove;
        }
        if (this.smf92stp() != 7) {
            return Collections.emptyList();
        }
        this.m_FileSystemMove = Util.sectionsFromTriplet(this.m_FileSystemMove, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), FileSystemMove::create);
        return this.m_FileSystemMove;
    }

    public List<FileSystemMigration> fileSystemMigrations() {
        if (this.m_FileSystemMigration != null) {
            return this.m_FileSystemMigration;
        }
        if (this.smf92stp() != 8) {
            return Collections.emptyList();
        }
        this.m_FileSystemMigration = Util.sectionsFromTriplet(this.m_FileSystemMigration, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), FileSystemMigration::create);
        return this.m_FileSystemMigration;
    }

    public List<FileOpen> fileOpens() {
        if (this.m_FileOpen != null) {
            return this.m_FileOpen;
        }
        if (this.smf92stp() != 10) {
            return Collections.emptyList();
        }
        this.m_FileOpen = Util.sectionsFromTriplet(this.m_FileOpen, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), FileOpen::create);
        return this.m_FileOpen;
    }

    public List<FileClose> FileCloses() {
        if (this.m_FileClose != null) {
            return this.m_FileClose;
        }
        if (this.smf92stp() != 11 && this.smf92stp() != 16) {
            return Collections.emptyList();
        }
        this.m_FileClose = Util.sectionsFromTriplet(this.m_FileClose, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), FileClose::create);
        return this.m_FileClose;
    }

    public List<MMap> mMaps() {
        if (this.m_MMap != null) {
            return this.m_MMap;
        }
        if (this.smf92stp() != 12) {
            return Collections.emptyList();
        }
        this.m_MMap = Util.sectionsFromTriplet(this.m_MMap, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), MMap::create);
        return this.m_MMap;
    }

    public List<MUnMap> mUnMaps() {
        if (this.m_MUnMap != null) {
            return this.m_MUnMap;
        }
        if (this.smf92stp() != 13) {
            return Collections.emptyList();
        }
        this.m_MUnMap = Util.sectionsFromTriplet(this.m_MUnMap, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), MUnMap::create);
        return this.m_MUnMap;
    }

    public List<FileDeleteRename> fileDeleteRenames() {
        if (this.m_FileDeleteRename != null) {
            return this.m_FileDeleteRename;
        }
        if (this.smf92stp() != 14) {
            return Collections.emptyList();
        }
        this.m_FileDeleteRename = Util.sectionsFromTriplet(this.m_FileDeleteRename, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), FileDeleteRename::create);
        return this.m_FileDeleteRename;
    }

    public List<FileSecurityAttrChange> fileSecurityAttrChanges() {
        if (this.m_FileSecurityAttrChange != null) {
            return this.m_FileSecurityAttrChange;
        }
        if (this.smf92stp() != 15) {
            return Collections.emptyList();
        }
        this.m_FileSecurityAttrChange = Util.sectionsFromTriplet(this.m_FileSecurityAttrChange, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), FileSecurityAttrChange::create);
        return this.m_FileSecurityAttrChange;
    }

    public List<FileAccess> fileAccesses() {
        if (this.m_FileAccess != null) {
            return this.m_FileAccess;
        }
        if (this.smf92stp() != 17) {
            return Collections.emptyList();
        }
        this.m_FileAccess = Util.sectionsFromTriplet(this.m_FileAccess, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), FileAccess::create);
        return this.m_FileAccess;
    }

    public List<FilesystemEvent> filesystemEvents() {
        if (this.m_FilesystemEvent != null) {
            return this.m_FilesystemEvent;
        }
        if (this.smf92stp() != 50) {
            return Collections.emptyList();
        }
        this.m_FilesystemEvent = Util.sectionsFromTriplet(this.m_FilesystemEvent, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), FilesystemEvent::create);
        return this.m_FilesystemEvent;
    }

    public List<CallCounts> callCounts() {
        if (this.m_CallCounts != null) {
            return this.m_CallCounts;
        }
        if (this.smf92stp() != 51) {
            return Collections.emptyList();
        }
        this.m_CallCounts = Util.sectionsFromTriplet(this.m_CallCounts, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), CallCounts::create);
        return this.m_CallCounts;
    }

    public List<UserCacheStatistics> userCacheStatistics() {
        if (this.m_UserCacheStatistics != null) {
            return this.m_UserCacheStatistics;
        }
        if (this.smf92stp() != 52) {
            return Collections.emptyList();
        }
        this.m_UserCacheStatistics = Util.sectionsFromTriplet(this.m_UserCacheStatistics, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), UserCacheStatistics::create);
        return this.m_UserCacheStatistics;
    }

    public List<MetadataCacheStatistics> metadataCacheStatistics() {
        if (this.m_MetadataCacheStatistics != null) {
            return this.m_MetadataCacheStatistics;
        }
        if (this.smf92stp() != 53) {
            return Collections.emptyList();
        }
        this.m_MetadataCacheStatistics = Util.sectionsFromTriplet(this.m_MetadataCacheStatistics, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), MetadataCacheStatistics::create);
        return this.m_MetadataCacheStatistics;
    }

    public List<LockAndSleepStatistics> lockAndSleepStatistics() {
        if (this.m_LockAndSleepStatistics != null) {
            return this.m_LockAndSleepStatistics;
        }
        if (this.smf92stp() != 54) {
            return Collections.emptyList();
        }
        this.m_LockAndSleepStatistics = Util.sectionsFromTriplet(this.m_LockAndSleepStatistics, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), LockAndSleepStatistics::create);
        return this.m_LockAndSleepStatistics;
    }

    public List<DiskIOStatistics> diskIOStatistics() {
        if (this.m_DiskIOStatistics != null) {
            return this.m_DiskIOStatistics;
        }
        if (this.smf92stp() != 55) {
            return Collections.emptyList();
        }
        this.m_DiskIOStatistics = Util.sectionsFromTriplet(this.m_DiskIOStatistics, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), DiskIOStatistics::create);
        return this.m_DiskIOStatistics;
    }

    public List<TokenManagerInformation> tokenManagerInformation() {
        if (this.m_TokenManagerInformation != null) {
            return this.m_TokenManagerInformation;
        }
        if (this.smf92stp() != 56) {
            return Collections.emptyList();
        }
        this.m_TokenManagerInformation = Util.sectionsFromTriplet(this.m_TokenManagerInformation, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), TokenManagerInformation::create);
        return this.m_TokenManagerInformation;
    }

    public List<MemoryUsage> memoryUsage() {
        if (this.m_MemoryUsage != null) {
            return this.m_MemoryUsage;
        }
        if (this.smf92stp() != 57) {
            return Collections.emptyList();
        }
        this.m_MemoryUsage = Util.sectionsFromTriplet(this.m_MemoryUsage, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), MemoryUsage::create);
        return this.m_MemoryUsage;
    }

    public List<TransmitReceiveStatistics> transmitReceiveStatistics() {
        if (this.m_TransmitReceiveStatistics != null) {
            return this.m_TransmitReceiveStatistics;
        }
        if (this.smf92stp() != 58) {
            return Collections.emptyList();
        }
        this.m_TransmitReceiveStatistics = Util.sectionsFromTriplet(this.m_TransmitReceiveStatistics, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), TransmitReceiveStatistics::create);
        return this.m_TransmitReceiveStatistics;
    }

    public List<PerFilesystemUsageInformation> perFilesystemUsageInformation() {
        if (this.m_PerFilesystemUsageInformation != null) {
            return this.m_PerFilesystemUsageInformation;
        }
        if (this.smf92stp() != 59) {
            return Collections.emptyList();
        }
        this.m_PerFilesystemUsageInformation = Util.sectionsFromTriplet(this.m_PerFilesystemUsageInformation, this.data, () -> this.smf92dof(), () -> this.smf92dln(), () -> this.smf92don(), PerFilesystemUsageInformation::create);
        return this.m_PerFilesystemUsageInformation;
    }

    public int smf92len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf92seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf92flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean smf92ssf() {
        return Util.ConvertFlag(this.data, this.smf92flg(), 128);
    }

    public boolean smf92sbt() {
        return Util.ConvertFlag(this.data, this.smf92flg(), 64);
    }

    public int smf92rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf92tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf92tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf92dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf92dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf92sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf92wid() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smf92stp() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int smf92sdl() {
        return Util.ConvertUnsignedBinary2(this.data, 26);
    }

    public int smf92sof() {
        return Util.ConvertSignedBinary4(this.data, 28);
    }

    public int smf92sln() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smf92son() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int smf92iof() {
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smf92iln() {
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smf92ion() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public int smf92dof() {
        return Util.ConvertSignedBinary4(this.data, 44);
    }

    public int smf92dln() {
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf92don() {
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    static enum Field {
        smf92len(0, 2),
        smf92seg(2, 2),
        smf92flg(4, 1),
        smf92rty(5, 1),
        smf92tme(6, 4),
        smf92dte(10, 4),
        smf92sid(14, 4),
        smf92wid(18, 4),
        smf92stp(22, 2),
        smf92sdl(26, 2),
        smf92sof(28, 4),
        smf92sln(32, 2),
        smf92son(34, 2),
        smf92iof(36, 4),
        smf92iln(40, 2),
        smf92ion(42, 2),
        smf92dof(44, 4),
        smf92dln(48, 2),
        smf92don(50, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

