/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf92;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf92.CacheSpaceEntry;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class UserCacheStatistics
extends SmfData {
    private List<CacheSpaceEntry> _cacheSpace = null;
    public static final int SMF92ST2_LEN = 224;

    private UserCacheStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ZonedDateTime smf92uct() {
        return Util.Binary16StckeTime(this.data, 0);
    }

    public BigInteger smf92uctRawValue() {
        return Util.ConvertBigInteger(this.data, 0, 16);
    }

    public long smf92ucsch() {
        return Util.ConvertUnsignedBinary8(this.data, 16);
    }

    public BigInteger smf92ucschAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 16);
    }

    public long smf92ucset() {
        return Util.ConvertUnsignedBinary8(this.data, 24);
    }

    public BigInteger smf92ucsetAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public long smf92ucfsy() {
        return Util.ConvertUnsignedBinary8(this.data, 32);
    }

    public BigInteger smf92ucfsyAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 32);
    }

    public long smf92ucunm() {
        return Util.ConvertUnsignedBinary8(this.data, 40);
    }

    public BigInteger smf92ucunmAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 40);
    }

    public long smf92ucrd() {
        return Util.ConvertUnsignedBinary8(this.data, 48);
    }

    public BigInteger smf92ucrdAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 48);
    }

    public long smf92ucrda() {
        return Util.ConvertUnsignedBinary8(this.data, 56);
    }

    public BigInteger smf92ucrdaAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    public long smf92ucwr() {
        return Util.ConvertUnsignedBinary8(this.data, 64);
    }

    public BigInteger smf92ucwrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    public long smf92ucget() {
        return Util.ConvertUnsignedBinary8(this.data, 72);
    }

    public BigInteger smf92ucgetAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 72);
    }

    public long smf92ucfl() {
        return Util.ConvertUnsignedBinary8(this.data, 80);
    }

    public BigInteger smf92ucflAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public long smf92ucdel() {
        return Util.ConvertUnsignedBinary8(this.data, 88);
    }

    public BigInteger smf92ucdelAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 88);
    }

    public long smf92ucrdf() {
        return Util.ConvertUnsignedBinary8(this.data, 96);
    }

    public BigInteger smf92ucrdfAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 96);
    }

    public long smf92ucwrf() {
        return Util.ConvertUnsignedBinary8(this.data, 104);
    }

    public BigInteger smf92ucwrfAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 104);
    }

    public long smf92ucrio() {
        return Util.ConvertUnsignedBinary8(this.data, 112);
    }

    public BigInteger smf92ucrioAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 112);
    }

    public long smf92ucwrs() {
        return Util.ConvertUnsignedBinary8(this.data, 120);
    }

    public BigInteger smf92ucwrsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 120);
    }

    public long smf92ucwre() {
        return Util.ConvertUnsignedBinary8(this.data, 128);
    }

    public BigInteger smf92ucwreAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 128);
    }

    public long smf92ucwrr() {
        return Util.ConvertUnsignedBinary8(this.data, 136);
    }

    public BigInteger smf92ucwrrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 136);
    }

    public long smf92ucrwr() {
        return Util.ConvertUnsignedBinary8(this.data, 144);
    }

    public BigInteger smf92ucrwrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 144);
    }

    public long smf92ucww() {
        return Util.ConvertUnsignedBinary8(this.data, 152);
    }

    public BigInteger smf92ucwwAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 152);
    }

    public long smf92ucwwf() {
        return Util.ConvertUnsignedBinary8(this.data, 160);
    }

    public BigInteger smf92ucwwfAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 160);
    }

    public long smf92ucwwe() {
        return Util.ConvertUnsignedBinary8(this.data, 168);
    }

    public BigInteger smf92ucwweAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 168);
    }

    public long smf92ucwwr() {
        return Util.ConvertUnsignedBinary8(this.data, 176);
    }

    public BigInteger smf92ucwwrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 176);
    }

    public long smf92ucrst() {
        return Util.ConvertUnsignedBinary8(this.data, 184);
    }

    public BigInteger smf92ucrstAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 184);
    }

    public int smf92uccs() {
        return Util.ConvertSignedBinary4(this.data, 192);
    }

    public long smf92ucpcs() {
        return Util.ConvertUnsignedBinary4(this.data, 196);
    }

    public long smf92ucss() {
        return Util.ConvertUnsignedBinary4(this.data, 200);
    }

    public long smf92ucpgs() {
        return Util.ConvertUnsignedBinary4(this.data, 204);
    }

    public long smf92ucpgt() {
        return Util.ConvertUnsignedBinary4(this.data, 208);
    }

    public long smf92ucpgf() {
        return Util.ConvertUnsignedBinary4(this.data, 212);
    }

    public long smf92ucsgc() {
        return Util.ConvertUnsignedBinary4(this.data, 216);
    }

    public int smf92ucdsl() {
        return Util.ConvertSignedBinary4(this.data, 220);
    }

    public List<CacheSpaceEntry> cacheSpaceEntries() {
        if (this._cacheSpace == null) {
            ArrayList<CacheSpaceEntry> list = new ArrayList<CacheSpaceEntry>(this.smf92uccs());
            for (int i = 0; i < this.smf92uccs(); ++i) {
                list.add(CacheSpaceEntry.create(this.data, 224 + i * this.smf92ucdsl(), this.smf92ucdsl()));
            }
            this._cacheSpace = Collections.unmodifiableList(list);
        }
        return this._cacheSpace;
    }

    public static UserCacheStatistics create(byte[] Data2, int offset, int length) {
        return new UserCacheStatistics(Data2, offset, length);
    }

    static enum Field {
        smf92uct(0, 16),
        smf92ucsch(16, 8),
        smf92ucset(24, 8),
        smf92ucfsy(32, 8),
        smf92ucunm(40, 8),
        smf92ucrd(48, 8),
        smf92ucrda(56, 8),
        smf92ucwr(64, 8),
        smf92ucget(72, 8),
        smf92ucfl(80, 8),
        smf92ucdel(88, 8),
        smf92ucrdf(96, 8),
        smf92ucwrf(104, 8),
        smf92ucrio(112, 8),
        smf92ucwrs(120, 8),
        smf92ucwre(128, 8),
        smf92ucwrr(136, 8),
        smf92ucrwr(144, 8),
        smf92ucww(152, 8),
        smf92ucwwf(160, 8),
        smf92ucwwe(168, 8),
        smf92ucwwr(176, 8),
        smf92ucrst(184, 8),
        smf92uccs(192, 4),
        smf92ucpcs(196, 4),
        smf92ucss(200, 4),
        smf92ucpgs(204, 4),
        smf92ucpgt(208, 4),
        smf92ucpgf(212, 4),
        smf92ucsgc(216, 4),
        smf92ucdsl(220, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

