/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf98;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf98.JobPriority;
import com.blackhillsoftware.smf.smf98.JobSize;
import com.blackhillsoftware.smf.smf98.ProcessorClass;

public final class JobIndex
extends SmfData {
    private int[] m_smf98jobIdxActivityArea = null;

    private JobIndex(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public ProcessorClass cpuType() {
        return ProcessorClass.from(this.cpuTypeRawValue());
    }

    public int cpuTypeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public JobPriority jobPriority() {
        return JobPriority.from(this.jobPriorityRawValue());
    }

    public int jobPriorityRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public JobSize jobSize() {
        return JobSize.from(this.jobSizeRawValue());
    }

    public int jobSizeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 4);
    }

    public int customJobSize() {
        return Util.ConvertUnsignedBinary2(this.data, 4);
    }

    public int[] activityArea() {
        if (this.m_smf98jobIdxActivityArea != null) {
            return this.m_smf98jobIdxActivityArea;
        }
        int entryLength = 2;
        int entryCount = (this.data.length - Field.activityArea.offset) / entryLength;
        if (this.data.length >= 6) {
            int[] result = new int[entryCount];
            for (int i = 0; i < entryCount; ++i) {
                result[i] = Util.ConvertUnsignedBinary2(this.data, Field.activityArea.offset + i * entryLength);
            }
            this.m_smf98jobIdxActivityArea = result;
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(6) + " Data length: " + Integer.toString(1));
    }

    public static JobIndex create(byte[] Data2, int offset, int length) {
        return new JobIndex(Data2, offset, length);
    }

    static enum Field {
        cpuType(0, 2),
        jobPriority(2, 2),
        jobSize(4, 2),
        customJobSize(4, 2),
        activityArea(6, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

