/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf98.zos;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf98.JobPriority;
import com.blackhillsoftware.smf.smf98.JobSize;
import com.blackhillsoftware.smf.smf98.ProcessorClass;
import com.blackhillsoftware.smf.smf98.zos.AddressSpaceSpinLock;
import com.blackhillsoftware.smf.smf98.zos.ExecutionEfficiency;
import com.blackhillsoftware.smf.smf98.zos.WorkUnit;
import java.util.List;

public final class AddressSpaceConsumption
extends SmfData {
    private byte[] parentdata;
    private List<ExecutionEfficiency> m_ExecutionEfficiency = null;
    private List<WorkUnit> m_WorkUnit = null;
    private List<AddressSpaceSpinLock> m_AddressSpaceSpinLock = null;

    private AddressSpaceConsumption(byte[] Data2, int offset, int length, byte[] parentdata) {
        super(Data2, offset, length);
        this.parentdata = parentdata;
    }

    public List<ExecutionEfficiency> executionEfficiency() {
        this.m_ExecutionEfficiency = Util.sectionsFromTriplet(this.m_ExecutionEfficiency, this.parentdata, () -> this.exEffOff(), () -> this.exEffLen(), () -> this.exEffNum(), ExecutionEfficiency::create);
        return this.m_ExecutionEfficiency;
    }

    public List<WorkUnit> workUnit() {
        this.m_WorkUnit = Util.sectionsFromTriplet(this.m_WorkUnit, this.parentdata, () -> this.workUnitOff(), () -> this.workUnitLen(), () -> this.workUnitNum(), WorkUnit::create);
        return this.m_WorkUnit;
    }

    public List<AddressSpaceSpinLock> addressSpaceSpinLock() {
        this.m_AddressSpaceSpinLock = Util.sectionsFromTriplet(this.m_AddressSpaceSpinLock, this.parentdata, () -> this.spinLockOff(), () -> this.spinLockLen(), () -> this.spinLockNum(), AddressSpaceSpinLock::create);
        return this.m_AddressSpaceSpinLock;
    }

    public int procClassRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public ProcessorClass procClass() {
        return ProcessorClass.from(this.procClassRawValue());
    }

    public JobPriority priorityBucket() {
        return JobPriority.from(Util.ConvertUnsignedBinary2(this.data, 2));
    }

    public int priorityBucketRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public JobSize subBucket() {
        return JobSize.from(Util.ConvertUnsignedBinary2(this.data, 4));
    }

    public int subBucketRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 4);
    }

    public int exEffOff() {
        return Util.ConvertSignedBinary4(this.data, 8);
    }

    public int exEffLen() {
        return Util.ConvertUnsignedBinary2(this.data, 12);
    }

    public int exEffNum() {
        return Util.ConvertUnsignedBinary2(this.data, 14);
    }

    public int workUnitOff() {
        return Util.ConvertSignedBinary4(this.data, 16);
    }

    public int workUnitLen() {
        return Util.ConvertUnsignedBinary2(this.data, 20);
    }

    public int workUnitNum() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public int spinLockOff() {
        return Util.ConvertSignedBinary4(this.data, 24);
    }

    public int spinLockLen() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int spinLockNum() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public static AddressSpaceConsumption create(byte[] Data2, int offset, int length) {
        return new AddressSpaceConsumption(Data2, offset, length, Data2);
    }

    static enum Field {
        procClass(0, 2),
        priorityBucket(2, 2),
        subBucket(4, 2),
        exEffOff(8, 4),
        exEffLen(12, 2),
        exEffNum(14, 2),
        workUnitOff(16, 4),
        workUnitLen(20, 2),
        workUnitNum(22, 2),
        spinLockOff(24, 4),
        spinLockLen(28, 2),
        spinLockNum(30, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

