/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf98.zos;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class AsidInfo
extends SmfData {
    public static final int SMF98_1_AsidInfo_BrokenUp = 128;

    private AsidInfo(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int asid() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int dp() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public int flags() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public boolean brokenUp() {
        return Util.ConvertFlag(this.data, this.flags(), 128);
    }

    public long seqnum() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public String jobName() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public Duration cpAllTaskSrbTimeTod() {
        return Util.Binary8StckInterval(this.data, 16);
    }

    public double cpAllTaskSrbTimeTodSeconds() {
        return Util.ToSeconds(this.cpAllTaskSrbTimeTod());
    }

    public long cpAllTaskSrbTimeTodRawValue() {
        return Util.ConvertSignedBinary8(this.data, 16);
    }

    public Duration ziipAllTaskSrbTimeTod() {
        return Util.Binary8StckInterval(this.data, 24);
    }

    public double ziipAllTaskSrbTimeTodSeconds() {
        return Util.ToSeconds(this.ziipAllTaskSrbTimeTod());
    }

    public long ziipAllTaskSrbTimeTodRawValue() {
        return Util.ConvertSignedBinary8(this.data, 24);
    }

    public long cpAllTd1EqCpi() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long ziipAllTd1EqCpi() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public Duration zcbpAllTaskSrbTimeTod() {
        return Util.Binary8StckInterval(this.data, 40);
    }

    public double zcbpAllTaskSrbTimeTodSeconds() {
        return Util.ToSeconds(this.zcbpAllTaskSrbTimeTod());
    }

    public long zcbpAllTaskSrbTimeTodRawValue() {
        return Util.ConvertSignedBinary8(this.data, 40);
    }

    public long zcbpAllTd1EqCpi() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public static AsidInfo create(byte[] Data2, int offset, int length) {
        return new AsidInfo(Data2, offset, length);
    }

    static enum Field {
        asid(0, 2),
        dp(2, 1),
        flags(3, 1),
        seqnum(4, 4),
        jobName(8, 8),
        cpAllTaskSrbTimeTod(16, 8),
        ziipAllTaskSrbTimeTod(24, 8),
        cpAllTd1EqCpi(32, 4),
        ziipAllTd1EqCpi(36, 4),
        zcbpAllTaskSrbTimeTod(40, 8),
        zcbpAllTd1EqCpi(48, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

