/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.values;

import java.util.HashMap;
import java.util.Map;

public enum BoostClass {
    IPL(1),
    SHUTDOWN(2),
    RP(3),
    NOT_DEFINED(-16);

    private static Map<Integer, BoostClass> valueMap;
    private final int boostclass;

    private BoostClass(int boostclass) {
        this.boostclass = boostclass;
    }

    public static BoostClass from(int value) {
        BoostClass result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int boostclass() {
        return this.boostclass;
    }

    static {
        valueMap = new HashMap<Integer, BoostClass>();
        for (BoostClass x : BoostClass.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.boostclass, x);
        }
    }
}

