/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.svpol;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public final class ServicePolicyInformation
extends SmfData {
    public static final int SVPOLIOM = 128;
    public static final int SVPOLDAM = 64;
    public static final int SVPOLIOE = 32;
    public static final int SVPOLDGM = 16;

    private ServicePolicyInformation(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String svpolnsp() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public String svpoldsp() {
        return Util.ConvertEbcdic(this.data, 8, 32);
    }

    public ZonedDateTime svpoltpa() {
        return Util.Binary8xStckTime(this.data, 40);
    }

    public BigInteger svpoltpaRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 40);
    }

    public String svpolipu() {
        return Util.ConvertEbcdic(this.data, 48, 8);
    }

    public String svpolsna() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public long svpolseq() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long svpolasn() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public String svpolidn() {
        return Util.ConvertEbcdic(this.data, 72, 8);
    }

    public ZonedDateTime svpoltdi() {
        return Util.Binary8xStckTime(this.data, 80);
    }

    public BigInteger svpoltdiRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public String svpolidu() {
        return Util.ConvertEbcdic(this.data, 88, 8);
    }

    public String svpolids() {
        return Util.ConvertEbcdic(this.data, 96, 8);
    }

    public String svpolidd() {
        return Util.ConvertEbcdic(this.data, 104, 32);
    }

    public long svpolcpu() {
        return Util.ConvertUnsignedBinary4(this.data, 136);
    }

    public long svpolioc() {
        return Util.ConvertUnsignedBinary4(this.data, 140);
    }

    public long svpolmso() {
        return Util.ConvertUnsignedBinary4(this.data, 144);
    }

    public long svpolsrb() {
        return Util.ConvertUnsignedBinary4(this.data, 148);
    }

    public String svpolecp() {
        return Util.ConvertEbcdic(this.data, 152, 4);
    }

    public String svpoleio() {
        return Util.ConvertEbcdic(this.data, 156, 4);
    }

    public String svpolems() {
        return Util.ConvertEbcdic(this.data, 160, 8);
    }

    public String svpolesr() {
        return Util.ConvertEbcdic(this.data, 168, 4);
    }

    public int svpolfl2() {
        return Util.ConvertUnsignedBinary1(this.data, 172);
    }

    public boolean svpoliom() {
        return Util.ConvertFlag(this.data, this.svpolfl2(), 128);
    }

    public boolean svpoldam() {
        return Util.ConvertFlag(this.data, this.svpolfl2(), 64);
    }

    public boolean svpolioe() {
        return Util.ConvertFlag(this.data, this.svpolfl2(), 32);
    }

    public boolean svpoldgm() {
        return Util.ConvertFlag(this.data, this.svpolfl2(), 16);
    }

    public String svpolenm() {
        return Util.ConvertEbcdic(this.data, 176, 64);
    }

    public String svpolevr() {
        return Util.ConvertEbcdic(this.data, 240, 64);
    }

    public String svpolepu() {
        return Util.ConvertEbcdic(this.data, 304, 16);
    }

    public String svpolemu() {
        return Util.ConvertEbcdic(this.data, 320, 16);
    }

    public int svpolesq() {
        return Util.ConvertUnsignedBinary2(this.data, 336);
    }

    public int svpolepi() {
        return Util.ConvertUnsignedBinary2(this.data, 338);
    }

    public int svpolesi() {
        return Util.ConvertUnsignedBinary2(this.data, 340);
    }

    public int svpolenw() {
        return Util.ConvertUnsignedBinary2(this.data, 342);
    }

    public int svpolens() {
        return Util.ConvertUnsignedBinary2(this.data, 344);
    }

    public int svpolenp() {
        return Util.ConvertUnsignedBinary2(this.data, 346);
    }

    public ZonedDateTime svpoleat() {
        return Util.Binary8MicrosSinceEpochTime(this.data, 348);
    }

    public BigInteger svpoleatRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 348);
    }

    public String svpolcpg() {
        return Util.ConvertEbcdic(this.data, 356, 40);
    }

    public static ServicePolicyInformation create(byte[] Data2, int offset, int length) {
        return new ServicePolicyInformation(Data2, offset, length);
    }

    static enum Field {
        svpolnsp(0, 8),
        svpoldsp(8, 32),
        svpoltpa(40, 8),
        svpolipu(48, 8),
        svpolsna(56, 8),
        svpolseq(64, 4),
        svpolasn(68, 4),
        svpolidn(72, 8),
        svpoltdi(80, 8),
        svpolidu(88, 8),
        svpolids(96, 8),
        svpolidd(104, 32),
        svpolcpu(136, 4),
        svpolioc(140, 4),
        svpolmso(144, 4),
        svpolsrb(148, 4),
        svpolecp(152, 4),
        svpoleio(156, 4),
        svpolems(160, 8),
        svpolesr(168, 4),
        svpolfl2(172, 1),
        svpolenm(176, 64),
        svpolevr(240, 64),
        svpolepu(304, 16),
        svpolemu(320, 16),
        svpolesq(336, 2),
        svpolepi(338, 2),
        svpolesi(340, 2),
        svpolenw(342, 2),
        svpolens(344, 2),
        svpolenp(346, 2),
        svpoleat(348, 8),
        svpolcpg(356, 40);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

