/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json;

import com.blackhillsoftware.json.internal.Hexadecimal;
import com.blackhillsoftware.smf.SmfData;

class CicsTermInfo
extends SmfData {
    private int[] flags;
    private final int NATURE_NOTAPPLICABLE = 0;
    private final int NATURE_TERMINAL = 1;
    private final int NATURE_SESSION = 2;
    private final int SESST_NONE = 0;
    private final int SESST_IRC = 1;
    private final int SESST_IRC_XM = 2;
    private final int SESST_IRC_XCF = 3;
    private final int SESST_LU61 = 4;
    private final int SESST_LU62_SING = 5;
    private final int SESST_LU62_PARA = 6;
    private final int AM_NONE = 0;
    private final int AM_VTAM = 1;
    private final int AM_BSAM = 3;
    private final int AM_BGAM = 6;
    private final int AM_CONSOLE = 7;

    CicsTermInfo(byte[] flagBytes) {
        super(null);
        if (flagBytes.length != 4) {
            throw new IllegalArgumentException("Expected 4 bytes of flags, got " + this.flags.length);
        }
        this.flags = new int[4];
        for (int i = 0; i < 4; ++i) {
            this.flags[i] = flagBytes[i] & 0xFF;
        }
    }

    public String nature() {
        switch (this.flags[0]) {
            case 0: {
                return null;
            }
            case 1: {
                return "Terminal";
            }
            case 2: {
                return "Session";
            }
        }
        return Hexadecimal.byteString[this.flags[0]];
    }

    public String sessionType() {
        if (this.flags[0] != 2) {
            return null;
        }
        switch (this.flags[1]) {
            case 0: {
                return null;
            }
            case 1: {
                return "IRC";
            }
            case 2: {
                return "IRC XM";
            }
            case 3: {
                return "IRC XCF";
            }
            case 4: {
                return "LU61";
            }
            case 5: {
                return "LU62 Single";
            }
            case 6: {
                return "LU62 Parallel";
            }
        }
        return Hexadecimal.byteString[this.flags[1]];
    }

    public String accessMethod() {
        switch (this.flags[2]) {
            case 0: {
                return null;
            }
            case 1: {
                return "VTAM";
            }
            case 3: {
                return "BSAM";
            }
            case 6: {
                return "BGAM";
            }
            case 7: {
                return "Console";
            }
        }
        return Hexadecimal.byteString[this.flags[2]];
    }

    public String deviceType() {
        if (this.flags[3] == 0) {
            return null;
        }
        return Hexadecimal.byteString[this.flags[3]];
    }
}

