/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json;

import com.blackhillsoftware.json.CicsTaskFlags;
import com.blackhillsoftware.json.CicsTermInfo;
import com.blackhillsoftware.json.CicsTranFlags;
import com.blackhillsoftware.json.CicsTxEntry;
import com.blackhillsoftware.smf.cics.monitoring.DictionaryEntry;
import com.blackhillsoftware.smf.cics.monitoring.PerformanceRecord;
import com.blackhillsoftware.smf.cics.monitoring.fields.Field;
import com.blackhillsoftware.smf.cics.monitoring.fields.MonitoringField;
import java.math.BigInteger;
import java.util.Locale;
import java.util.function.BiFunction;

final class CicsTxEntryDefinition {
    private String jsonName;
    private final String cmodName;
    private String ident;
    private String cmodHead;
    private final DictionaryEntry dictionaryEntry;
    private final MonitoringField field;
    private boolean alwaysInclude;
    private final BiFunction<PerformanceRecord, DictionaryEntry, Object> specialFunction;

    CicsTxEntryDefinition(DictionaryEntry dictionaryEntry, boolean alwaysInclude) {
        this.cmodName = dictionaryEntry.cmodname();
        this.ident = dictionaryEntry.entryId();
        this.cmodHead = dictionaryEntry.cmodhead();
        this.dictionaryEntry = dictionaryEntry;
        this.field = Field.get((String)this.cmodName, (String)this.ident) != null ? Field.get((String)this.cmodName, (String)this.ident) : dictionaryEntry.field();
        this.jsonName = this.field.getName().toLowerCase(Locale.ROOT);
        this.alwaysInclude = alwaysInclude;
        this.specialFunction = CicsTxEntryDefinition.setSpecialFunction(this.field);
    }

    private static BiFunction<PerformanceRecord, DictionaryEntry, Object> setSpecialFunction(MonitoringField field) {
        switch (field.getName()) {
            case "RTYPE": {
                return CicsTxEntryDefinition::rtypeValue;
            }
            case "TERMINFO": {
                return CicsTxEntryDefinition::terminfoValue;
            }
            case "TRANFLAG": 
            case "OTRANFLG": {
                return CicsTxEntryDefinition::tranflagValue;
            }
            case "TASKFLAG": {
                return CicsTxEntryDefinition::taskflagValue;
            }
            case "TRANNUM": 
            case "OTRANNUM": 
            case "PTTRANNO": 
            case "PHTRANNO": {
                return CicsTxEntryDefinition::trannumValue;
            }
            case "NETUOWSX": 
            case "TRNGRPID": {
                return CicsTxEntryDefinition::hexValue;
            }
        }
        return null;
    }

    CicsTxEntry verboseEntry(PerformanceRecord perf) {
        return new CicsTxEntry(this.cmodName, this.ident, this.cmodHead, this.getFieldValue(perf));
    }

    Object getFieldValue(PerformanceRecord perf) {
        try {
            return this.specialFunction == null ? perf.getField(this.dictionaryEntry) : this.specialFunction.apply(perf, this.dictionaryEntry);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    static Object rtypeValue(PerformanceRecord perf, DictionaryEntry dictionaryEntry) {
        return perf.getFieldAsString(dictionaryEntry).substring(3);
    }

    static Object terminfoValue(PerformanceRecord perf, DictionaryEntry dictionaryEntry) {
        if (perf.getCountField(dictionaryEntry) == 0L) {
            return null;
        }
        return new CicsTermInfo(perf.getFieldBytes(dictionaryEntry));
    }

    static Object tranflagValue(PerformanceRecord perf, DictionaryEntry dictionaryEntry) {
        if (perf.getCountFieldAsBigInteger(dictionaryEntry).equals(BigInteger.ZERO)) {
            return null;
        }
        return new CicsTranFlags(perf.getFieldBytes(dictionaryEntry));
    }

    static Object taskflagValue(PerformanceRecord perf, DictionaryEntry dictionaryEntry) {
        return new CicsTaskFlags(perf.getFieldBytes(dictionaryEntry));
    }

    static Object hexValue(PerformanceRecord perf, DictionaryEntry dictionaryEntry) {
        return perf.getFieldAsHex(dictionaryEntry);
    }

    static Object trannumValue(PerformanceRecord txData, DictionaryEntry dictionaryEntry) {
        if (txData.isValidPacked(dictionaryEntry)) {
            return txData.getPackedField(dictionaryEntry);
        }
        byte first = txData.getFieldBytes(dictionaryEntry)[0];
        if (first == 64 || first == 0) {
            String fieldAsString = txData.getFieldAsString(dictionaryEntry);
            if (fieldAsString.length() > 1) {
                fieldAsString = fieldAsString.substring(1);
            }
            return fieldAsString;
        }
        return txData.getFieldAsString(dictionaryEntry);
    }

    String cmodName() {
        return this.cmodName;
    }

    String ident() {
        return this.ident;
    }

    String cmodHead() {
        return this.cmodHead;
    }

    DictionaryEntry getDictionaryEntry() {
        return this.dictionaryEntry;
    }

    MonitoringField getField() {
        return this.field;
    }

    boolean alwaysInclude() {
        return this.alwaysInclude;
    }

    String getJsonName() {
        return this.jsonName;
    }
}

