/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json;

import com.blackhillsoftware.json.util.CompositeEntry;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class CompositeEntryTypeAdapter
extends TypeAdapter<CompositeEntry> {
    Gson gson;

    CompositeEntryTypeAdapter(Gson gson) {
        this.gson = gson;
    }

    public void write(JsonWriter out, CompositeEntry src) throws IOException {
        if (src == null) {
            out.nullValue();
            return;
        }
        int nextUnnamed = 1;
        List<String> existingNames = null;
        out.beginObject();
        for (CompositeEntry.Element entry : src.getElements()) {
            Class<?> clazz;
            Object o = entry.getObject();
            if (entry.getName() != null) {
                out.name(entry.getName());
                if (o == null) {
                    out.nullValue();
                    continue;
                }
                TypeAdapter<Object> entryAdapter = this.typeAdapterHelper(o);
                entryAdapter.write(out, entry.getObject());
                continue;
            }
            Class<?> clazz2 = clazz = o == null ? null : o.getClass();
            if (clazz == null || clazz.isArray() || o instanceof Number || o instanceof String || o instanceof Boolean || o instanceof Byte || o instanceof Character || Iterable.class.isAssignableFrom(clazz)) {
                if (existingNames == null) {
                    existingNames = this.getExistingNames(src);
                }
                String name = null;
                while (name == null || existingNames.contains(name)) {
                    name = "unnamed_" + Integer.toString(nextUnnamed);
                    ++nextUnnamed;
                }
                out.name(name);
                if (o == null) {
                    out.nullValue();
                    continue;
                }
                TypeAdapter<Object> entryAdapter = this.typeAdapterHelper(o);
                entryAdapter.write(out, o);
                continue;
            }
            JsonElement element = this.gson.toJsonTree(o);
            if (element.isJsonObject()) {
                JsonObject object = (JsonObject)element;
                for (Map.Entry objectEntry : object.entrySet()) {
                    out.name((String)objectEntry.getKey());
                    TypeAdapter entryAdapter = this.typeAdapterHelper(objectEntry.getValue());
                    entryAdapter.write(out, objectEntry.getValue());
                }
                continue;
            }
            if (existingNames == null) {
                existingNames = this.getExistingNames(src);
            }
            String name = null;
            while (name == null || existingNames.contains(name)) {
                name = "unnamed_" + Integer.toString(nextUnnamed);
                ++nextUnnamed;
            }
            out.name(name);
            TypeAdapter<JsonElement> entryAdapter = this.typeAdapterHelper(element);
            entryAdapter.write(out, (Object)element);
        }
        out.endObject();
    }

    <T> TypeAdapter<T> typeAdapterHelper(T object) {
        return this.gson.getAdapter(object.getClass());
    }

    public CompositeEntry read(JsonReader in) throws IOException {
        throw new UnsupportedOperationException();
    }

    private List<String> getExistingNames(CompositeEntry src) {
        return src.getElements().stream().filter(x -> x.getName() != null).map(x -> x.getName()).collect(Collectors.toList());
    }
}

