/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json;

import com.blackhillsoftware.json.EasySmfTypeAdapterFactory;
import com.blackhillsoftware.json.SerializeByteArray;
import com.blackhillsoftware.json.SerializeDuration;
import com.blackhillsoftware.json.SerializeInstant;
import com.blackhillsoftware.json.SerializeLocalDate;
import com.blackhillsoftware.json.SerializeLocalDateTime;
import com.blackhillsoftware.json.SerializeLocalTime;
import com.blackhillsoftware.json.SerializeOffsetDateTime;
import com.blackhillsoftware.json.SerializeOffsetTime;
import com.blackhillsoftware.json.SerializePeriod;
import com.blackhillsoftware.json.SerializeZoneId;
import com.blackhillsoftware.json.SerializeZoneOffset;
import com.blackhillsoftware.json.SerializeZonedDateTime;
import com.blackhillsoftware.json.internal.Configuration;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.cics.monitoring.fields.MonitoringField;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.function.Function;

public final class EasySmfGsonBuilder {
    private GsonBuilder builder;
    private Configuration config = new Configuration();

    public EasySmfGsonBuilder() {
        this.builder = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128, 8}).serializeSpecialFloatingPointValues().registerTypeAdapter(Duration.class, (Object)new SerializeDuration()).registerTypeAdapter(LocalDate.class, (Object)new SerializeLocalDate()).registerTypeAdapter(LocalDateTime.class, (Object)new SerializeLocalDateTime()).registerTypeAdapter(LocalTime.class, (Object)new SerializeLocalTime()).registerTypeAdapter(OffsetTime.class, (Object)new SerializeOffsetTime()).registerTypeAdapter(Period.class, (Object)new SerializePeriod()).registerTypeHierarchyAdapter(ZoneId.class, (Object)new SerializeZoneId()).registerTypeAdapter(ZoneOffset.class, (Object)new SerializeZoneOffset()).registerTypeAdapter(byte[].class, (Object)new SerializeByteArray());
    }

    public GsonBuilder getGsonBuilder() {
        this.builder.registerTypeAdapterFactory((TypeAdapterFactory)new EasySmfTypeAdapterFactory(this.config.clone()));
        return this.builder;
    }

    public Gson createGson() {
        this.builder.registerTypeAdapterFactory((TypeAdapterFactory)new EasySmfTypeAdapterFactory(this.config.clone()));
        return this.builder.create();
    }

    public EasySmfGsonBuilder includeRawValues(boolean value) {
        this.config.includeRawDataValues(value);
        return this;
    }

    public EasySmfGsonBuilder includeSectionType(boolean value) {
        this.config.includeSectionTypeName(value);
        return this;
    }

    public EasySmfGsonBuilder durationAsDuration(boolean value) {
        this.config.includeDurationAsDuration(value);
        return this;
    }

    public EasySmfGsonBuilder durationAsSeconds(boolean value) {
        this.config.includeDurationAsSeconds(value);
        return this;
    }

    public EasySmfGsonBuilder timesAsEpochSeconds(boolean value) {
        this.config.timesAsEpochSeconds(value);
        this.builder.registerTypeAdapter(Instant.class, (Object)new SerializeInstant(value)).registerTypeAdapter(OffsetDateTime.class, (Object)new SerializeOffsetDateTime(value)).registerTypeAdapter(ZonedDateTime.class, (Object)new SerializeZonedDateTime(value));
        return this;
    }

    public EasySmfGsonBuilder includeUnsetFlags(boolean value) {
        this.config.includeUnsetFlags(value);
        return this;
    }

    public EasySmfGsonBuilder includeDeprecated(boolean value) {
        this.config.includeDeprecated(value);
        return this;
    }

    public EasySmfGsonBuilder setPrettyPrinting() {
        this.builder.setPrettyPrinting();
        return this;
    }

    public EasySmfGsonBuilder cicsVerbose(boolean value) {
        this.config.cicsVerbose(value);
        return this;
    }

    public EasySmfGsonBuilder includeZeroValues(boolean value) {
        this.config.includeZeros(value);
        return this;
    }

    public EasySmfGsonBuilder includeEmptyStrings(boolean value) {
        this.config.includeEmptyStrings(value);
        return this;
    }

    public EasySmfGsonBuilder cicsClockDetail(boolean value) {
        this.config.cicsClockDetail(value);
        return this;
    }

    public EasySmfGsonBuilder cicsExcludeGroup(String name) {
        this.config.cicsAddExcludeGroup(name);
        return this;
    }

    public EasySmfGsonBuilder exclude(String name) {
        this.config.addExcludeMethod(name);
        return this;
    }

    public EasySmfGsonBuilder exclude(Class<? extends SmfData> targetType, String name) {
        this.config.addExcludeMethod(targetType, name);
        return this;
    }

    public EasySmfGsonBuilder exclude(MonitoringField field) {
        this.config.addExcludeField(field);
        return this;
    }

    public EasySmfGsonBuilder include(String name) {
        this.config.alwaysIncludeMethod(name);
        return this;
    }

    public EasySmfGsonBuilder include(MonitoringField field) {
        this.config.alwaysIncludeMethod(field);
        return this;
    }

    public EasySmfGsonBuilder include(Class<? extends SmfData> targetType, String name) {
        this.config.alwaysIncludeMethodForClass(targetType, name);
        return this;
    }

    public EasySmfGsonBuilder alias(Class<? extends SmfData> targetType, String fromName, String toName) {
        this.config.addAliasForClass(targetType, fromName, toName);
        return this;
    }

    public EasySmfGsonBuilder avoidScientificNotation(boolean value) {
        this.config.setAvoidScientificNotation(value);
        return this;
    }

    public EasySmfGsonBuilder decimalPlaces(int value) {
        if (value < 1 || value > 9) {
            throw new IllegalArgumentException("Decimal places must be between 1 and 9 inclusive.");
        }
        this.config.setDecimalPlaces(value);
        return this;
    }

    public EasySmfGsonBuilder addEntry(Class<? extends SmfData> targetType, String name, Object value) {
        this.config.addFixedEntryForClass(targetType, name, value);
        return this;
    }

    public <T extends SmfData> EasySmfGsonBuilder calculateEntry(Class<T> targetType, String name, Function<T, Object> value) {
        this.config.addCalculatedEntryForClass(targetType, name, value);
        return this;
    }
}

