/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json;

import com.blackhillsoftware.json.SerializeCicsClockFlags;
import com.blackhillsoftware.json.SerializeDouble;
import com.blackhillsoftware.json.internal.CalculatedValue;
import com.blackhillsoftware.json.internal.Configuration;
import com.blackhillsoftware.smf.cics.monitoring.CicsClock;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

final class SerializeCicsClock
extends TypeAdapter<CicsClock> {
    private Configuration config;
    private TypeAdapter<Duration> duration = null;
    private TypeAdapter<BigInteger> rawvalue = null;
    private TypeAdapter<Double> seconds = null;
    private TypeAdapter<Integer> period = null;
    private TypeAdapter<CicsClock> flags = null;
    private Gson gson;
    private String timerLabel = "timer";
    private String secondsLabel = "seconds";
    private String rawvalueLabel = "timerRawValue";
    private String periodLabel = "count";
    private String flagsLabel = "flags";
    Map<String, String> fixedEntries = null;
    Set<Map.Entry<String, CalculatedValue<?>>> calculatedEntries = null;

    SerializeCicsClock(Configuration config, Gson gson) {
        this.setup(config, gson);
    }

    public void write(JsonWriter out, CicsClock value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        if (this.config.cicsClockDetail()) {
            this.detailedClock(out, value);
        } else {
            out.value(this.secondsValue(value));
        }
    }

    public CicsClock read(JsonReader in) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void detailedClock(JsonWriter out, CicsClock src) throws IOException {
        out.beginObject();
        if (this.duration != null) {
            out.name(this.timerLabel);
            this.duration.write(out, (Object)src.timer());
        }
        if (this.seconds != null) {
            out.name(this.secondsLabel);
            this.seconds.write(out, (Object)src.timerSeconds());
        }
        if (this.rawvalue != null) {
            out.name(this.rawvalueLabel);
            this.rawvalue.write(out, (Object)src.timerRawValue());
        }
        if (this.period != null) {
            out.name(this.periodLabel);
            this.period.write(out, (Object)src.count());
        }
        if (this.flags != null && (this.config.includeUnsetFlags() || src.flags() != 0)) {
            out.name(this.flagsLabel);
            this.flags.write(out, (Object)src);
        }
        if (this.fixedEntries != null) {
            for (Map.Entry<String, Object> entry : this.fixedEntries.entrySet()) {
                out.name(entry.getKey()).jsonValue((String)entry.getValue());
            }
        }
        if (this.calculatedEntries != null) {
            for (Map.Entry<String, Object> entry : this.calculatedEntries) {
                out.name(entry.getKey());
                Object o = ((CalculatedValue)entry.getValue()).calculate(src);
                if (o == null) {
                    out.nullValue();
                    continue;
                }
                TypeAdapter adapter = this.gson.getAdapter(o.getClass());
                adapter.write(out, o);
            }
        }
        out.endObject();
    }

    private Number secondsValue(CicsClock src) {
        return this.config.avoidScientificNotation() ? (Number)SerializeDouble.getNumber(src.timerSeconds(), this.config.getDecimalPlaces()) : (Number)src.timerSeconds();
    }

    private void setup(Configuration config, Gson gson) {
        Map<String, String> aliases;
        this.config = config;
        this.gson = gson;
        if (config.alwaysInclude(CicsClock.class, "timer") || config.includeDurationAsDuration() && !config.excludeName(CicsClock.class, "timer")) {
            this.duration = gson.getAdapter(Duration.class);
        }
        if (config.alwaysInclude(CicsClock.class, "timerSeconds") || config.includeDurationAsSeconds() && !config.excludeName(CicsClock.class, "timerSeconds")) {
            this.seconds = gson.getAdapter(Double.class);
        }
        if (config.alwaysInclude(CicsClock.class, "timerRawValue") || config.includeRawDataValues() && !config.excludeName(CicsClock.class, "timerRawValue")) {
            this.rawvalue = gson.getAdapter(BigInteger.class);
        }
        if (config.alwaysInclude(CicsClock.class, "periodCount") || !config.excludeName(CicsClock.class, "periodCount")) {
            this.period = gson.getAdapter(Integer.class);
        }
        if (config.alwaysInclude(CicsClock.class, "flags") || !config.excludeName(CicsClock.class, "flags")) {
            this.flags = new SerializeCicsClockFlags();
        }
        this.timerLabel = (aliases = config.getAliasByClass(CicsClock.class)).containsKey(this.timerLabel) ? aliases.get(this.timerLabel) : this.timerLabel;
        this.secondsLabel = aliases.containsKey(this.secondsLabel) ? aliases.get(this.secondsLabel) : this.secondsLabel;
        this.rawvalueLabel = aliases.containsKey(this.rawvalueLabel) ? aliases.get(this.rawvalueLabel) : this.rawvalueLabel;
        this.periodLabel = aliases.containsKey(this.periodLabel) ? aliases.get(this.periodLabel) : this.periodLabel;
        String string = this.flagsLabel = aliases.containsKey(this.flagsLabel) ? aliases.get(this.flagsLabel) : this.flagsLabel;
        if (config.fixedEntriesForClass(CicsClock.class) != null) {
            this.fixedEntries = new LinkedHashMap<String, String>();
            for (Map.Entry<String, Object> entry : config.fixedEntriesForClass(CicsClock.class)) {
                String json = gson.toJson(entry.getValue());
                this.fixedEntries.put(entry.getKey(), json);
            }
        }
        this.calculatedEntries = config.calculatedValuesForClass(CicsClock.class);
    }
}

