/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json;

import com.blackhillsoftware.json.CicsTxEntry;
import com.blackhillsoftware.json.CicsTxEntryDefinition;
import com.blackhillsoftware.json.CicsTxSerializationInfo;
import com.blackhillsoftware.json.ClassMethod;
import com.blackhillsoftware.json.SerializeByteArray;
import com.blackhillsoftware.json.internal.CalculatedValue;
import com.blackhillsoftware.json.internal.Configuration;
import com.blackhillsoftware.smf.Data;
import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.cics.CicsInstanceId;
import com.blackhillsoftware.smf.cics.monitoring.CicsClock;
import com.blackhillsoftware.smf.cics.monitoring.Dictionary;
import com.blackhillsoftware.smf.cics.monitoring.DictionaryEntry;
import com.blackhillsoftware.smf.cics.monitoring.PerformanceRecord;
import com.blackhillsoftware.smf.cics.monitoring.fields.MultiCountField;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

final class SerializeData
extends TypeAdapter<Data> {
    private static final Object[] emptyArgs = new Object[0];
    private static final String bigIntegerSuffix = "AsBigInteger";
    private static final SerializeByteArray byteArraySerializer = new SerializeByteArray();
    private Map<String, String> fixedEntries = null;
    private Set<Map.Entry<String, CalculatedValue<?>>> calculatedEntries = null;
    private Class<?> clazz;
    private Map<String, ClassMethod> methods;
    private Gson gson;
    private Map<CicsInstanceId, CicsTxSerializationInfo> cicstxInfo = new HashMap<CicsInstanceId, CicsTxSerializationInfo>();
    private ThreadLocal<CicsTxSerializationInfo> lastCicsInfo = new ThreadLocal();
    private Configuration config;
    private TypeAdapter<String> stringTypeAdapter;
    private TypeAdapter<Long> longTypeAdapter;
    private TypeAdapter<BigInteger> bigIntegerTypeAdapter;
    private TypeAdapter<CicsClock> cicsClockTypeAdapter;
    private TypeAdapter<ZonedDateTime> zonedDateTimeTypeAdapter;
    private TypeAdapter<List<BigInteger>> multiCountTypeAdapter;
    private TypeAdapter<CicsTxEntry> verboseTxAdapter;

    <T> SerializeData(Gson gson, TypeToken<T> typeToken, Configuration config) {
        this.gson = gson;
        this.config = config;
        this.stringTypeAdapter = gson.getAdapter(String.class);
        this.longTypeAdapter = gson.getAdapter(Long.class);
        this.bigIntegerTypeAdapter = gson.getAdapter(BigInteger.class);
        this.cicsClockTypeAdapter = gson.getAdapter(CicsClock.class);
        this.zonedDateTimeTypeAdapter = gson.getAdapter(ZonedDateTime.class);
        this.verboseTxAdapter = gson.getAdapter(CicsTxEntry.class);
        this.multiCountTypeAdapter = gson.getAdapter((TypeToken)new TypeToken<List<BigInteger>>(){});
        this.clazz = typeToken.getRawType();
        if (config.fixedEntriesForClass(this.clazz) != null) {
            this.fixedEntries = new LinkedHashMap<String, String>();
            for (Map.Entry<String, Object> entry : config.fixedEntriesForClass(this.clazz)) {
                String json = gson.toJson(entry.getValue());
                this.fixedEntries.put(entry.getKey(), json);
            }
        }
        this.calculatedEntries = config.calculatedValuesForClass(this.clazz);
        this.methods = SerializeData.buildMethodList(this.clazz, gson, config);
    }

    public void write(JsonWriter out, Data src) throws IOException {
        if (src == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        if (SmfData.class.equals(this.clazz)) {
            out.name("data");
            byteArraySerializer.write(out, src.getBytes());
        }
        if (Data.class.equals(this.clazz)) {
            out.name("data");
            byteArraySerializer.write(out, src.getBytes());
        }
        if (this.fixedEntries != null) {
            for (Map.Entry<String, Object> entry : this.fixedEntries.entrySet()) {
                out.name(entry.getKey()).jsonValue((String)entry.getValue());
            }
        }
        if (this.calculatedEntries != null) {
            for (Map.Entry<String, Object> entry : this.calculatedEntries) {
                out.name(entry.getKey());
                Object o = ((CalculatedValue)entry.getValue()).calculate(src);
                if (o == null) {
                    out.nullValue();
                    continue;
                }
                TypeAdapter adapter = this.gson.getAdapter(o.getClass());
                adapter.write(out, o);
            }
        }
        for (Map.Entry<String, Object> entry : this.methods.entrySet()) {
            ClassMethod classMethod = (ClassMethod)entry.getValue();
            Method method = classMethod.getMethod();
            try {
                Object value = method.invoke((Object)src, emptyArgs);
                if (value == src) continue;
                if (value != null && classMethod.isIterable()) {
                    if (!((Iterable)value).iterator().hasNext()) continue;
                    out.name(entry.getKey());
                    classMethod.getAdapter().write(out, value);
                    continue;
                }
                if (!classMethod.isAlwaysInclude() && !this.config.includeValue(value)) continue;
                out.name(entry.getKey());
                classMethod.getAdapter().write(out, value);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null) {
                    if (e.getCause().getClass().equals(FieldNotPresentException.class) || e.getCause().getClass().equals(NotAvailableException.class)) continue;
                    out.name(entry.getKey()).value(e.getCause().toString());
                    continue;
                }
                if (e.getTargetException() != null) {
                    if (e.getTargetException().getClass().equals(FieldNotPresentException.class) || e.getTargetException().getClass().equals(NotAvailableException.class)) continue;
                    out.name(entry.getKey()).value(e.getTargetException().toString());
                    continue;
                }
                out.name(entry.getKey()).value(e.toString());
            }
            catch (FieldNotPresentException e) {
            }
            catch (NotAvailableException e) {
            }
            catch (IllegalAccessException e) {
                out.name(entry.getKey()).value(e.toString());
            }
            catch (IllegalArgumentException e) {
                out.name(entry.getKey()).value(e.toString());
            }
            catch (SecurityException e) {
                out.name(entry.getKey()).value(e.toString());
            }
        }
        if (src instanceof PerformanceRecord) {
            this.serializeCicsTx((PerformanceRecord)src, out);
        }
        out.endObject();
    }

    public Data read(JsonReader in) throws IOException {
        throw new UnsupportedOperationException();
    }

    private static Map<String, ClassMethod> buildMethodList(Class<?> clazz, Gson gson, Configuration config) {
        LinkedHashMap<String, ClassMethod> methods = new LinkedHashMap<String, ClassMethod>();
        if (config.includeSectionTypeName()) {
            String clName = clazz.getSimpleName();
            config.addFixedEntryForClass(clazz, "sectionType", clName);
        }
        ArrayList heirarchy = new ArrayList();
        heirarchy.add(clazz);
        while (clazz.getSuperclass() != Object.class && clazz.getSuperclass() != SmfData.class && clazz.getSuperclass() != Data.class) {
            clazz = clazz.getSuperclass();
            heirarchy.add(clazz);
        }
        Collections.reverse(heirarchy);
        for (Class clazz2 : heirarchy) {
            List<Method> allMethods = Arrays.asList(clazz2.getDeclaredMethods());
            Map valueMethods = allMethods.stream().filter(x -> config.includeMethod(c, (Method)x)).filter(x -> !Iterable.class.isAssignableFrom(x.getReturnType())).filter(x -> !SmfData.class.isAssignableFrom(x.getReturnType())).filter(x -> !Data.class.isAssignableFrom(x.getReturnType())).map(x -> new ClassMethod((Method)x, (TypeAdapter<? super Object>)gson.getAdapter(x.getReturnType()), config.alwaysInclude(c, x.getName()))).sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toMap(ClassMethod::getName, Function.identity(), (o1, o2) -> o1, LinkedHashMap::new));
            Map otherMethods = allMethods.stream().filter(x -> config.includeMethod(c, (Method)x)).filter(x -> !valueMethods.containsKey(x.getName())).map(x -> new ClassMethod((Method)x, (TypeAdapter<? super Object>)gson.getAdapter(x.getReturnType()), config.alwaysInclude(c, x.getName()))).sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toMap(ClassMethod::getName, Function.identity(), (o1, o2) -> o1, LinkedHashMap::new));
            List bigIntegerNames = valueMethods.keySet().stream().filter(entry -> entry.endsWith(bigIntegerSuffix)).collect(Collectors.toList());
            for (String string : bigIntegerNames) {
                String nonBigIntegerName = string.substring(0, string.length() - bigIntegerSuffix.length());
                if (!valueMethods.containsKey(nonBigIntegerName)) continue;
                valueMethods.put(nonBigIntegerName, (ClassMethod)valueMethods.get(string));
                valueMethods.remove(string);
            }
            methods.putAll(valueMethods);
            methods.putAll(otherMethods);
            for (Map.Entry entry2 : config.getAliasByClass(clazz).entrySet()) {
                if (!methods.containsKey(entry2.getKey())) continue;
                if (methods.containsKey(entry2.getValue())) {
                    throw new IllegalArgumentException("Alias newname already exists: " + clazz.getName() + " " + (String)entry2.getValue());
                }
                methods.put((String)entry2.getValue(), (ClassMethod)methods.get(entry2.getKey()));
                methods.remove(entry2.getKey());
            }
        }
        return methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeCicsTx(PerformanceRecord perf, JsonWriter out) throws IOException {
        CicsTxSerializationInfo cicsInfo = this.lastCicsInfo.get();
        if (cicsInfo == null || perf.getDictionary() != cicsInfo.getDictionary()) {
            Map<CicsInstanceId, CicsTxSerializationInfo> map = this.cicstxInfo;
            synchronized (map) {
                cicsInfo = this.cicstxInfo.get(perf.getCicsInstanceId());
                if (cicsInfo == null || cicsInfo.getDictionary() != perf.getDictionary()) {
                    cicsInfo = new CicsTxSerializationInfo(perf.getDictionary(), this.buildCicsEntryList(perf.getDictionary()));
                    this.cicstxInfo.put(perf.getCicsInstanceId(), cicsInfo);
                }
            }
            this.lastCicsInfo.set(cicsInfo);
        }
        if (cicsInfo.getTxEntries().size() == 0) {
            out.name("information").value("No Dictionary");
        } else if (this.config.cicsTxVerbose()) {
            ArrayList<CicsTxEntry> stats = new ArrayList<CicsTxEntry>(cicsInfo.entryCount());
            for (CicsTxEntryDefinition cicsTxEntryDefinition : cicsInfo.getTxEntries()) {
                CicsTxEntry txEntry = cicsTxEntryDefinition.verboseEntry(perf);
                if (!cicsTxEntryDefinition.alwaysInclude() && !this.config.includeValue(txEntry.value())) continue;
                stats.add(txEntry);
            }
            out.name("values");
            out.beginArray();
            for (CicsTxEntry cicsTxEntry : stats) {
                this.verboseTxAdapter.write(out, (Object)cicsTxEntry);
            }
            out.endArray();
        } else {
            for (CicsTxEntryDefinition entry : cicsInfo.getTxEntries()) {
                Object object = entry.getFieldValue(perf);
                if (object == null) {
                    out.name(entry.getJsonName());
                    out.nullValue();
                    continue;
                }
                if (!entry.alwaysInclude() && !this.config.includeValue(object)) continue;
                out.name(entry.getJsonName());
                if (object instanceof BigInteger) {
                    this.bigIntegerTypeAdapter.write(out, (Object)((BigInteger)object));
                    continue;
                }
                if (object instanceof String) {
                    this.stringTypeAdapter.write(out, (Object)((String)object));
                    continue;
                }
                if (object instanceof CicsClock) {
                    this.cicsClockTypeAdapter.write(out, (Object)((CicsClock)object));
                    continue;
                }
                if (object instanceof ZonedDateTime) {
                    this.zonedDateTimeTypeAdapter.write(out, (Object)((ZonedDateTime)object));
                    continue;
                }
                if (entry.getField() instanceof MultiCountField) {
                    this.multiCountTypeAdapter.write(out, (Object)((List)object));
                    continue;
                }
                TypeAdapter adapter = this.gson.getAdapter(object.getClass());
                adapter.write(out, object);
            }
        }
    }

    private List<CicsTxEntryDefinition> buildCicsEntryList(Dictionary dictionary) {
        ArrayList<CicsTxEntryDefinition> txEntries = new ArrayList<CicsTxEntryDefinition>();
        if (dictionary != null) {
            for (DictionaryEntry entry : dictionary.entries()) {
                boolean exclude;
                boolean always = this.config.alwaysInclude(PerformanceRecord.class, entry.cmodhead()) || this.config.alwaysInclude(PerformanceRecord.class, entry.cmodhead() + "_" + entry.entryId());
                boolean bl = exclude = this.config.excludeName(PerformanceRecord.class, entry.cmodhead()) || this.config.excludeName(PerformanceRecord.class, entry.cmodhead() + "_" + entry.entryId());
                if (!always && (exclude || this.config.excludeCicsGroup(entry.cmodname()))) continue;
                txEntries.add(new CicsTxEntryDefinition(entry, always));
            }
        }
        return txEntries;
    }
}

