/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json;

import com.blackhillsoftware.json.internal.Configuration;
import com.blackhillsoftware.json.util.HashKey;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

final class SerializeHashKey
extends TypeAdapter<HashKey> {
    private Gson gson;
    private Configuration config;

    public SerializeHashKey(Configuration config, Gson gson) {
        this.config = config;
        this.gson = gson;
    }

    public void write(JsonWriter out, HashKey value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        ArrayList<Map.Entry<String, Object>> todo = new ArrayList<Map.Entry<String, Object>>();
        for (Map.Entry<String, Object> entry : value.getNamedValues().entrySet()) {
            if (!this.config.includeValue(entry.getValue()) && !this.config.alwaysInclude(HashKey.class, entry.getKey())) continue;
            todo.add(entry);
        }
        if (todo.size() == 0) {
            out.nullValue();
            return;
        }
        out.beginObject();
        for (Map.Entry<String, Object> entry : todo) {
            out.name(entry.getKey());
            if (entry.getValue() == null) {
                out.nullValue();
                continue;
            }
            TypeAdapter adapter = this.gson.getAdapter(entry.getValue().getClass());
            adapter.write(out, entry.getValue());
        }
        out.endObject();
    }

    public HashKey read(JsonReader in) throws IOException {
        throw new UnsupportedOperationException();
    }
}

