/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

final class SerializeInstant
extends TypeAdapter<Instant> {
    private final boolean asEpochSeconds;
    private static ThreadLocal<DecimalFormat> secondFormat = ThreadLocal.withInitial(() -> new DecimalFormat("0"));
    private static ThreadLocal<DecimalFormat> fractionFormat = ThreadLocal.withInitial(() -> new DecimalFormat("000000000"));

    SerializeInstant(boolean asEpochSeconds) {
        this.asEpochSeconds = asEpochSeconds;
    }

    public void write(JsonWriter out, Instant value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        if (this.asEpochSeconds) {
            out.value(SerializeInstant.getNumber(value));
        } else {
            out.value(value.atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT));
        }
    }

    public Instant read(JsonReader in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static Number getNumber(final Instant src) {
        Number n = new Number(){
            private static final long serialVersionUID = 8228502183576598224L;
            private final Instant value;
            {
                this.value = src;
            }

            @Override
            public long longValue() {
                long f = this.value.getEpochSecond();
                return f;
            }

            @Override
            public int intValue() {
                long f = this.value.getEpochSecond();
                return (int)f;
            }

            @Override
            public float floatValue() {
                double f = this.value.getEpochSecond();
                double fraction = (double)this.value.getNano() / 1.0E9;
                return (float)(f + fraction);
            }

            @Override
            public double doubleValue() {
                double f = this.value.getEpochSecond();
                double fraction = (double)this.value.getNano() / 1.0E9;
                return f + fraction;
            }

            public String toString() {
                String seconds = ((DecimalFormat)secondFormat.get()).format(this.value.getEpochSecond());
                String fraction = ((DecimalFormat)fractionFormat.get()).format(this.value.getNano());
                return seconds + "." + fraction.replaceAll("0+$", "");
            }
        };
        return n;
    }
}

