/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json.cics;

import com.blackhillsoftware.json.internal.CicsSummaryElapsed;
import com.blackhillsoftware.json.internal.CicsSummaryEntry;
import com.blackhillsoftware.json.internal.Configuration;
import com.blackhillsoftware.smf.cics.monitoring.Dictionary;
import com.blackhillsoftware.smf.cics.monitoring.DictionaryEntry;
import com.blackhillsoftware.smf.cics.monitoring.PerformanceRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class CicsTransactionGroup {
    private Configuration config;
    private Dictionary originalDictionary = null;
    private AtomicInteger count = new AtomicInteger(0);
    private List<CicsSummaryEntry> entries = null;

    CicsTransactionGroup(Configuration config) {
        this.config = config;
    }

    private synchronized void buildEntryList(Configuration config, Dictionary dictionary) {
        if (this.entries == null) {
            this.originalDictionary = dictionary;
            ArrayList<CicsSummaryEntry> result = new ArrayList<CicsSummaryEntry>();
            result.add(new CicsSummaryElapsed("elapsed"));
            for (DictionaryEntry entry : dictionary.entries()) {
                boolean exclude;
                boolean always = config.alwaysInclude(PerformanceRecord.class, entry.cmodhead()) || config.alwaysInclude(PerformanceRecord.class, entry.cmodhead() + "_" + entry.entryId());
                boolean bl = exclude = config.excludeName(PerformanceRecord.class, entry.cmodhead()) || config.excludeName(PerformanceRecord.class, entry.cmodhead() + "_" + entry.entryId());
                if (!always && (exclude || config.excludeCicsGroup(entry.cmodname()))) continue;
                result.add(CicsSummaryEntry.forField(entry, config));
            }
            this.entries = result;
        }
    }

    public void add(PerformanceRecord performanceRecord) {
        this.count.incrementAndGet();
        if (this.entries == null) {
            this.buildEntryList(this.getConfig(), performanceRecord.getDictionary());
        }
        boolean sameDictionary = performanceRecord.getDictionary().equals((Object)this.originalDictionary);
        for (CicsSummaryEntry entry : this.entries) {
            try {
                entry.add(performanceRecord, sameDictionary);
            }
            catch (Exception e) {
                entry.addError(e.getMessage());
            }
        }
    }

    public synchronized List<CicsSummaryEntry> getSummary() {
        return this.entries == null ? Collections.emptyList() : this.entries;
    }

    public synchronized int getCount() {
        return this.count.get();
    }

    Configuration getConfig() {
        return this.config;
    }
}

