/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json.internal;

import com.blackhillsoftware.json.internal.CicsSummaryEntry;
import com.blackhillsoftware.json.internal.Configuration;
import com.blackhillsoftware.smf.cics.monitoring.DictionaryEntry;
import com.blackhillsoftware.smf.cics.monitoring.PerformanceRecord;
import com.blackhillsoftware.smf.cics.monitoring.fields.PackedField;
import java.util.LinkedHashMap;

public class CicsSummaryPacked
extends CicsSummaryEntry {
    private PackedField field;
    private long min = 0L;
    private long max = 0L;
    private long total = 0L;

    public CicsSummaryPacked(String name, PackedField field, DictionaryEntry entry) {
        super(name, entry);
        this.field = field;
    }

    @Override
    public synchronized void add(PerformanceRecord section, boolean sameDictionary) {
        long value = sameDictionary ? section.getPackedField(this.getDictionaryEntry()) : section.getField(this.field);
        this.total += value;
        this.min = !this.containsData || value < this.min ? value : this.min;
        this.max = !this.containsData || value > this.max ? value : this.max;
        this.containsData = true;
    }

    @Override
    public synchronized Object getValue(Configuration config) {
        if (this.total == 0L) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("min", this.min);
        result.put("max", this.max);
        result.put("total", this.total);
        if (this.errors() != null) {
            result.put("errors", this.errors());
        }
        return result;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getTotal() {
        return this.total;
    }
}

