/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json.internal;

import com.blackhillsoftware.json.internal.CicsSummaryEntry;
import com.blackhillsoftware.json.internal.Configuration;
import com.blackhillsoftware.smf.cics.monitoring.DictionaryEntry;
import com.blackhillsoftware.smf.cics.monitoring.PerformanceRecord;
import com.blackhillsoftware.smf.cics.monitoring.fields.TimestampField;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;

public class CicsSummaryTimestamp
extends CicsSummaryEntry {
    private TimestampField field;
    private ZonedDateTime min = null;
    private ZonedDateTime max = null;

    public CicsSummaryTimestamp(String name, TimestampField field, DictionaryEntry entry) {
        super(name, entry);
        this.field = field;
    }

    @Override
    public synchronized void add(PerformanceRecord section, boolean sameDictionary) {
        ZonedDateTime time = sameDictionary ? section.getTimestampField(this.getDictionaryEntry()) : section.getField(this.field);
        this.min = this.min == null || time.isBefore(this.min) ? time : this.min;
        this.max = this.max == null || time.isAfter(this.max) ? time : this.max;
        this.containsData = true;
    }

    @Override
    public synchronized Object getValue(Configuration config) {
        if (this.min == null) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("min", this.min);
        result.put("max", this.max);
        if (this.errors() != null) {
            result.put("errors", this.errors());
        }
        return result;
    }

    public ZonedDateTime getMin() {
        return this.min;
    }

    public ZonedDateTime getMax() {
        return this.max;
    }
}

