/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json.internal;

import com.blackhillsoftware.json.internal.CalculatedValue;
import com.blackhillsoftware.json.internal.CicsSummaryClockDetailed;
import com.blackhillsoftware.json.internal.CicsSummaryClockSimple;
import com.blackhillsoftware.json.internal.CicsSummaryCountStats;
import com.blackhillsoftware.json.internal.CicsSummaryStringSet;
import com.blackhillsoftware.smf.Token;
import com.blackhillsoftware.smf.cics.Smf110Record;
import com.blackhillsoftware.smf.cics.monitoring.CicsClock;
import com.blackhillsoftware.smf.cics.monitoring.DictionaryEntry;
import com.blackhillsoftware.smf.cics.monitoring.PerformanceRecord;
import com.blackhillsoftware.smf.cics.monitoring.fields.MonitoringField;
import com.blackhillsoftware.smf.db2.Smf100Record;
import com.blackhillsoftware.smf.db2.Smf101Record;
import com.blackhillsoftware.smf.db2.Smf102Record;
import com.blackhillsoftware.smf.db2.SmfDb2Record;
import com.blackhillsoftware.smf.smf30.Smf30Record;
import com.blackhillsoftware.smf.smf72.subtype3.ServiceReportClassPeriodDataSection;
import com.blackhillsoftware.smf.smf92.Smf92Record;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class Configuration
implements Cloneable {
    private Map<Class<?>, Map<String, Object>> fixedEntriesForClass = new LinkedHashMap();
    private Map<Class<?>, Map<String, CalculatedValue<?>>> calculatedValuesByClass = new LinkedHashMap();
    private Map<Class<?>, Map<String, String>> aliasByClass = new HashMap();
    private Map<Class<?>, Set<String>> alwaysIncludeMethodsByClass = new HashMap();
    private Map<Class<?>, Set<String>> excludeMethodsByClass = new HashMap();
    private Set<String> alwaysIncludeMethods = new HashSet<String>();
    private Set<String> excludeMethods = new HashSet<String>();
    private Set<String> excludeCicsGroups = new HashSet<String>();
    private boolean includeRawDataValues = false;
    private boolean includeSectionType = false;
    private boolean durationAsDuration = false;
    private boolean durationAsSeconds = true;
    private boolean epochTimes = false;
    private boolean avoidScientificNotation = false;
    private boolean includeUnsetFlags = true;
    private boolean includeDeprecated = false;
    private boolean includeZeros = true;
    private boolean includeEmptyStrings = true;
    private Integer decimalPlaces = null;
    private boolean cicsTxVerbose = false;
    private boolean cicsClockDetail = true;

    public Configuration clone() {
        try {
            Configuration other = (Configuration)super.clone();
            other.fixedEntriesForClass = this.copyNestedMap(this.fixedEntriesForClass);
            other.calculatedValuesByClass = this.copyNestedMap(this.calculatedValuesByClass);
            other.aliasByClass = this.copyNestedMap(this.aliasByClass);
            other.alwaysIncludeMethodsByClass = this.copyNestedSet(this.alwaysIncludeMethodsByClass);
            other.excludeMethodsByClass = this.copyNestedSet(this.excludeMethodsByClass);
            other.alwaysIncludeMethods = new HashSet<String>(this.alwaysIncludeMethods);
            other.excludeMethods = new HashSet<String>(this.excludeMethods);
            other.excludeCicsGroups = new HashSet<String>(this.excludeCicsGroups);
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone failed", e);
        }
    }

    private <T, U, V> Map<T, Map<U, V>> copyNestedMap(Map<T, Map<U, V>> current) {
        LinkedHashMap<T, LinkedHashMap<U, V>> result = new LinkedHashMap<T, LinkedHashMap<U, V>>();
        for (Map.Entry<T, Map<U, V>> entry : current.entrySet()) {
            result.put(entry.getKey(), new LinkedHashMap<U, V>(entry.getValue()));
        }
        return result;
    }

    private <T, U> Map<T, Set<U>> copyNestedSet(Map<T, Set<U>> current) {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<T, Set<U>> entry : current.entrySet()) {
            result.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        return result;
    }

    public Configuration() {
        this.addExcludeMethod(Smf30Record.class, "appcCumulativeResourceSections");
        this.addExcludeMethod(Smf30Record.class, "appcResourceSections");
        this.addExcludeMethod(Smf30Record.class, "completionSections");
        this.addExcludeMethod(Smf30Record.class, "ioActivitySections");
        this.addExcludeMethod(Smf30Record.class, "operatorSections");
        this.addExcludeMethod(Smf30Record.class, "performanceSections");
        this.addExcludeMethod(Smf30Record.class, "processorAccountingSections");
        this.addExcludeMethod(Smf30Record.class, "storageSections");
        this.addExcludeMethod(Smf92Record.class, "identificationSections");
        this.addExcludeMethod(Smf92Record.class, "subsystemSections");
        this.addExcludeMethod(Smf100Record.class, "decompress");
        this.addExcludeMethod(Smf101Record.class, "decompress");
        this.addExcludeMethod(Smf102Record.class, "decompress");
        this.addExcludeMethod(SmfDb2Record.class, "decompress");
        this.addExcludeMethod(Smf110Record.class, "decompress");
        this.addExcludeMethod(Smf110Record.class, "dictionary");
        this.addExcludeMethod(Smf110Record.class, "cicsInstance");
        this.addExcludeMethod(Smf110Record.class, "fieldConnectors");
        this.addExcludeMethod(Smf110Record.class, "mnHeader");
        this.addExcludeMethod(Token.class, "basicToken");
        this.addExcludeMethod(PerformanceRecord.class, "getDictionary");
        this.addExcludeMethod(PerformanceRecord.class, "getCicsInstanceId");
        this.addExcludeMethod(DictionaryEntry.class, "getFieldId");
        this.addExcludeMethod(ServiceReportClassPeriodDataSection.class, "controlSection");
        this.excludeMethods.addAll(Arrays.asList("dump", "getClass", "getBytes", "hashCode", "sanityCheck", "toString"));
    }

    public void includeRawDataValues(boolean value) {
        this.includeRawDataValues = value;
    }

    public boolean includeRawDataValues() {
        return this.includeRawDataValues;
    }

    public void includeSectionTypeName(boolean value) {
        this.includeSectionType = value;
    }

    public boolean includeSectionTypeName() {
        return this.includeSectionType;
    }

    public void includeDeprecated(boolean value) {
        this.includeDeprecated = value;
    }

    public boolean includeDeprecated() {
        return this.includeDeprecated;
    }

    public void includeDurationAsDuration(boolean value) {
        this.durationAsDuration = value;
    }

    public boolean includeDurationAsDuration() {
        return this.durationAsDuration;
    }

    public void includeDurationAsSeconds(boolean value) {
        this.durationAsSeconds = value;
    }

    public boolean timesAsEpochSeconds() {
        return this.epochTimes;
    }

    public void timesAsEpochSeconds(boolean value) {
        this.epochTimes = value;
    }

    public boolean includeUnsetFlags() {
        return this.includeUnsetFlags;
    }

    public void includeUnsetFlags(boolean value) {
        this.includeUnsetFlags = value;
    }

    public boolean includeDurationAsSeconds() {
        return this.durationAsSeconds;
    }

    public void cicsVerbose(boolean value) {
        this.cicsTxVerbose = value;
    }

    public boolean cicsTxVerbose() {
        return this.cicsTxVerbose;
    }

    public void includeZeros(boolean value) {
        this.includeZeros = value;
    }

    public boolean includeZeros() {
        return this.includeZeros;
    }

    public void includeEmptyStrings(boolean value) {
        this.includeEmptyStrings = value;
    }

    public boolean includeEmptyStrings() {
        return this.includeEmptyStrings;
    }

    public void cicsClockDetail(boolean value) {
        this.cicsClockDetail = value;
    }

    public boolean cicsClockDetail() {
        return this.cicsClockDetail;
    }

    public void cicsAddExcludeGroup(String value) {
        this.excludeCicsGroups.add(value);
    }

    public void addExcludeMethod(String value) {
        this.excludeMethods.add(value);
    }

    public void addExcludeField(MonitoringField value) {
        this.addExcludeMethod(PerformanceRecord.class, value.getName());
    }

    public boolean avoidScientificNotation() {
        return this.avoidScientificNotation;
    }

    public void setAvoidScientificNotation(boolean avoidScientificNotation) {
        this.avoidScientificNotation = avoidScientificNotation;
    }

    public void setDecimalPlaces(int places) {
        this.decimalPlaces = places;
    }

    public void alwaysIncludeMethodForClass(Class<?> type, String value) {
        this.alwaysIncludeMethodsByClass.computeIfAbsent(type, x -> new HashSet()).add(value);
    }

    public void addAliasForClass(Class<?> type, String fromName, String toName) {
        String result = this.aliasByClass.computeIfAbsent(type, x -> new HashMap()).putIfAbsent(fromName, toName);
        if (result != null) {
            throw new IllegalArgumentException("Duplicate value: " + type.getName() + " " + fromName);
        }
    }

    public Map<String, String> getAliasByClass(Class<?> clazz) {
        Map<String, String> result = this.aliasByClass.get(clazz);
        return result == null ? Collections.emptyMap() : result;
    }

    public void addFixedEntryForClass(Class<?> type, String key, Object value) {
        this.fixedEntriesForClass.computeIfAbsent(type, x -> new LinkedHashMap()).put(key, value);
    }

    public Set<Map.Entry<String, Object>> fixedEntriesForClass(Class<?> clazz) {
        Map<String, Object> result = this.fixedEntriesForClass.get(clazz);
        return result == null ? Collections.emptySet() : result.entrySet();
    }

    public <T> void addCalculatedEntryForClass(Class<T> type, String key, Function<T, Object> Value) {
        this.calculatedValuesByClass.computeIfAbsent(type, x -> new LinkedHashMap()).put(key, new CalculatedValue<T>(type, Value));
    }

    public Set<Map.Entry<String, CalculatedValue<?>>> calculatedValuesForClass(Class<?> clazz) {
        Map<String, CalculatedValue<?>> result = this.calculatedValuesByClass.get(clazz);
        return result == null ? Collections.emptySet() : result.entrySet();
    }

    public void alwaysIncludeMethod(String value) {
        this.alwaysIncludeMethods.add(value);
    }

    public void alwaysIncludeMethod(MonitoringField value) {
        this.alwaysIncludeMethodForClass(PerformanceRecord.class, value.getName());
    }

    public void addExcludeMethod(Class<?> type, String value) {
        this.excludeMethodsByClass.computeIfAbsent(type, x -> new HashSet()).add(value);
    }

    public boolean excludeCicsGroup(String name) {
        return this.excludeCicsGroups.contains(name);
    }

    public boolean includeMethod(Class<?> clazz, Method method) {
        int modifiers = method.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            return false;
        }
        if (Modifier.isStatic(modifiers)) {
            return false;
        }
        if (Modifier.isAbstract(modifiers)) {
            return false;
        }
        if (method.getParameterCount() != 0) {
            return false;
        }
        String name = method.getName();
        if (this.alwaysInclude(clazz, name)) {
            return true;
        }
        if (method.getAnnotation(Deprecated.class) != null && !this.includeDeprecated) {
            return false;
        }
        if (this.excludeName(clazz, name)) {
            return false;
        }
        return this.includeDurationAsDuration() || !method.getReturnType().equals(Duration.class);
    }

    public boolean alwaysInclude(Class<?> clazz, String name) {
        if (this.alwaysIncludeMethods.contains(name)) {
            return true;
        }
        Set<String> clazzMethods = this.alwaysIncludeMethodsByClass.get(clazz);
        return clazzMethods == null ? false : clazzMethods.contains(name);
    }

    public boolean excludeName(Class<?> clazz, String name) {
        if (this.excludeMethods.contains(name)) {
            return true;
        }
        Set<String> clazzMethods = this.excludeMethodsByClass.get(clazz);
        if (clazzMethods != null && clazzMethods.contains(name)) {
            return true;
        }
        if (!this.includeRawDataValues() && name.endsWith("RawValue")) {
            return true;
        }
        return !this.includeDurationAsSeconds() && name.endsWith("Seconds");
    }

    public boolean includeValue(Object value) {
        Boolean b;
        CicsSummaryStringSet stringSet;
        Object n;
        Object clock;
        if (!this.includeZeros() && (value instanceof CicsClock ? (clock = (CicsClock)value).flags() == 0 && clock.count() == 0 && clock.timer().equals(Duration.ZERO) : (value instanceof Number ? ((Number)(n = (Number)value)).doubleValue() == 0.0 : (value instanceof CicsSummaryClockSimple ? ((CicsSummaryClockSimple)(clock = (CicsSummaryClockSimple)value)).isZero() : (value instanceof CicsSummaryClockDetailed ? ((CicsSummaryClockDetailed)(clock = (CicsSummaryClockDetailed)value)).isZero() : value instanceof CicsSummaryCountStats && ((CicsSummaryCountStats)(n = (CicsSummaryCountStats)value)).isZero()))))) {
            return false;
        }
        if (!this.includeEmptyStrings() && (value instanceof String ? ((String)value).equals("") : value instanceof CicsSummaryStringSet && ((stringSet = (CicsSummaryStringSet)value).size() == 0 || stringSet.size() == 1 && stringSet.contains("")))) {
            return false;
        }
        return this.includeUnsetFlags() || !(value instanceof Boolean) || (b = (Boolean)value) != false;
    }

    public Integer getDecimalPlaces() {
        return this.decimalPlaces;
    }
}

