/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.json.util;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Objects;

public class MultiLineArray<T> {
    private static final String newline = System.lineSeparator();
    private State state = State.INITIAL;
    private Gson gson;

    public MultiLineArray(Gson gson) {
        Objects.requireNonNull(gson);
        this.gson = gson;
    }

    public static <T> String from(Iterable<T> src, Gson gson) {
        Objects.requireNonNull(src);
        Objects.requireNonNull(gson);
        MultiLineArray<T> array = new MultiLineArray<T>(gson);
        StringBuffer result = MultiLineArray.elements(src, array);
        if (result.length() > 0) {
            result.append(newline);
        }
        result.append(array.endArray());
        return result.toString();
    }

    public static <T> String from(T[] src, Gson gson) {
        Objects.requireNonNull(src);
        Objects.requireNonNull(gson);
        return MultiLineArray.from(Arrays.asList(src), gson);
    }

    public String element(Object element) {
        switch (this.state) {
            case STARTED: {
                return "," + this.gson.toJson(element);
            }
            case INITIAL: {
                this.state = State.STARTED;
                return "[" + this.gson.toJson(element);
            }
            case ENDED: {
                throw new IllegalStateException("Cannot add elements after ending the array");
            }
        }
        throw new IllegalStateException("Invalid state");
    }

    public String elements(Iterable<T> src) {
        Objects.requireNonNull(src);
        return MultiLineArray.elements(src, this).toString();
    }

    public String elements(T[] src) {
        Objects.requireNonNull(src);
        return this.elements(Arrays.asList(src));
    }

    private static <T> StringBuffer elements(Iterable<T> src, MultiLineArray<T> array) {
        StringBuffer result = new StringBuffer();
        for (T entry : src) {
            if (result.length() > 0) {
                result.append(newline);
            }
            result.append(array.element(entry));
        }
        return result;
    }

    public String endArray() {
        switch (this.state) {
            case STARTED: {
                this.state = State.ENDED;
                return "]";
            }
            case INITIAL: {
                this.state = State.ENDED;
                return "[]";
            }
            case ENDED: {
                return "";
            }
        }
        throw new IllegalStateException("Invalid state");
    }

    private static enum State {
        INITIAL,
        STARTED,
        ENDED;

    }
}

