/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf2json.cli;

import com.blackhillsoftware.json.EasySmfGsonBuilder;
import com.blackhillsoftware.json.util.MultiLineArray;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf2json.cli.Finished;
import com.blackhillsoftware.smf2json.cli.Smf2JsonInput;
import com.blackhillsoftware.smf2json.cli.Smf2JsonWriter;
import com.google.gson.Gson;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class Smf2JsonCLI {
    public static final List<Object> FINISHED = Finished.getInstance();
    private String[] args = null;
    private String description = "Generate JSON from SMF records";
    private Gson gson;
    private EasySmfGsonBuilder easySmfGsonBuilder;
    private List<Smf2JsonInput> inputs = new ArrayList<Smf2JsonInput>();
    private List<Integer> smfTypes = new ArrayList<Integer>();
    private List<SmfTypeSubtype> smfTypeSubtypes = new ArrayList<SmfTypeSubtype>();
    private boolean parallel = false;
    private LocalDateTime startTime = null;
    private LocalDateTime endTime = null;
    private Options options = null;
    private CommandLine commandLine = null;
    private boolean processRecordIsThreadsafe = false;
    private Object userLock = new Object();
    private Object writeLock = new Object();

    private void printUsage(Options options) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        StackTraceElement main = stack[stack.length - 1];
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(main.getClassName() + " [options] [<input-name> ...]", this.description + System.lineSeparator() + "Options:", options, System.lineSeparator() + "<input-name> : File(s) containing SMF records. Binary data, RECFM=U or V[B] including RDW." + System.lineSeparator() + "Specify <input-name> or --indd");
    }

    private Smf2JsonCLI() {
        this.easySmfGsonBuilder = new EasySmfGsonBuilder();
        this.initOptions();
    }

    public static Smf2JsonCLI create() {
        return new Smf2JsonCLI();
    }

    public Smf2JsonCLI description(String description) {
        this.description = description;
        return this;
    }

    public Smf2JsonCLI includeRecords(int smfType) {
        this.smfTypes.add(smfType);
        return this;
    }

    public Smf2JsonCLI includeRecords(int smfType, int subType) {
        this.smfTypeSubtypes.add(new SmfTypeSubtype(smfType, subType));
        return this;
    }

    public EasySmfGsonBuilder easySmfGsonBuilder() {
        return this.easySmfGsonBuilder;
    }

    public Options options() {
        if (this.commandLine != null) {
            throw new IllegalStateException("Options cannot be changed after command line has been parsed.");
        }
        return this.options;
    }

    private void initOptions() {
        this.options = new Options();
        this.options.addOption(Option.builder((String)"h").longOpt("help").desc("print this message and exit").build());
        this.options.addOption(Option.builder().longOpt("indd").hasArg(true).desc("input DD name").build());
        this.options.addOption(Option.builder().longOpt("outdd").hasArg(true).desc("output DD name").build());
        this.options.addOption(Option.builder().longOpt("out").hasArg(true).desc("output file name").build());
        this.options.addOption(Option.builder().longOpt("pretty").hasArg(false).desc("pretty print json").build());
        this.options.addOption(Option.builder().longOpt("parallel").hasArg(false).desc("use multiple threads").build());
        DateTimeFormatter dtf = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        LocalDateTime now = LocalDateTime.now().truncatedTo(ChronoUnit.SECONDS);
        this.options.addOption(Option.builder().longOpt("start").hasArg(true).desc("start SMF record time, inclusive e.g. " + dtf.format(now)).build());
        this.options.addOption(Option.builder().longOpt("end").hasArg(true).desc("end SMF record time, exclusive e.g. " + dtf.format(now)).build());
    }

    public CommandLine commandLine(String[] args) {
        Objects.requireNonNull(args);
        if (this.args != null && !Arrays.asList(args).equals(Arrays.asList(this.args))) {
            throw new IllegalArgumentException("Argument list has changed - it must be the same as previously supplied");
        }
        if (this.commandLine == null) {
            DefaultParser parser = new DefaultParser();
            try {
                this.commandLine = parser.parse(this.options, args);
            }
            catch (ParseException e1) {
                System.err.println(e1.getMessage());
                this.printUsage(this.options);
                System.exit(0);
            }
            if (this.commandLine.hasOption("help") || this.commandLine.getArgList().isEmpty() && !this.commandLine.hasOption("indd")) {
                this.printUsage(this.options);
                System.exit(0);
            }
        }
        return this.commandLine;
    }

    public Smf2JsonCLI processRecordIsThreadSafe(boolean isThreadSafe) {
        this.processRecordIsThreadsafe = isThreadSafe;
        return this;
    }

    public void start(Client client, String[] args) throws IOException {
        Objects.requireNonNull(client);
        Objects.requireNonNull(args);
        CommandLine cmd = this.commandLine(args);
        DateTimeFormatter dtf = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        if (cmd.hasOption("pretty")) {
            this.easySmfGsonBuilder.setPrettyPrinting();
        }
        if (cmd.hasOption("start")) {
            try {
                this.startTime = dtf.parse((CharSequence)cmd.getOptionValue("start"), LocalDateTime::from);
            }
            catch (DateTimeParseException e) {
                System.err.println("Error parsing start time: " + e.getMessage());
                this.printUsage(this.options);
                System.exit(0);
            }
        }
        if (cmd.hasOption("end")) {
            try {
                this.endTime = dtf.parse((CharSequence)cmd.getOptionValue("end"), LocalDateTime::from);
            }
            catch (DateTimeParseException e) {
                System.err.println("Error parsing end time: " + e.getMessage());
                this.printUsage(this.options);
                System.exit(0);
            }
        }
        this.gson = this.easySmfGsonBuilder.createGson();
        if (cmd.hasOption("indd")) {
            this.inputs.add(Smf2JsonInput.dd(cmd.getOptionValue("indd")));
        }
        for (String name : cmd.getArgList()) {
            this.inputs.add(Smf2JsonInput.file(name));
        }
        this.parallel = cmd.hasOption("parallel");
        try (Smf2JsonWriter writer = cmd.hasOption("out") ? Smf2JsonWriter.forFile(cmd.getOptionValue("out")) : (cmd.hasOption("outdd") ? Smf2JsonWriter.forDD(cmd.getOptionValue("outdd")) : Smf2JsonWriter.forStdout());){
            MultiLineArray<Object> arrayFormatter = new MultiLineArray<Object>(this.gson);
            for (Smf2JsonInput input : this.inputs) {
                SmfRecordReader reader = input.getReader();
                try {
                    this.setRecordTypes(reader);
                    Stream records = this.parallel ? (Stream)((Stream)reader.stream().parallel()).unordered() : reader.stream();
                    boolean finished = records.filter(x -> !(this.startTime != null && x.smfDateTime().isBefore(this.startTime) || this.endTime != null && !x.smfDateTime().isBefore(this.endTime))).map(record -> this.callProcessor(client, (SmfRecord)record)).filter(objectList -> objectList != null).map(objectList -> {
                        try {
                            this.writeJson(writer, (List<?>)objectList, arrayFormatter);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        return objectList;
                    }).filter(objectList -> objectList == FINISHED || objectList.contains(FINISHED)).findAny().isPresent();
                    if (!finished) continue;
                    break;
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            this.writeJson(writer, client.onEndOfData(), arrayFormatter);
            writer.writeLine(arrayFormatter.endArray());
        }
    }

    private List<?> callProcessor(Client processor, SmfRecord x) {
        if (!this.parallel || this.processRecordIsThreadsafe) {
            return this.callProcessorUnlocked(processor, x);
        }
        return this.callProcessorLocked(processor, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<?> callProcessorLocked(Client processor, SmfRecord x) {
        Object object = this.userLock;
        synchronized (object) {
            return processor.processRecord(x);
        }
    }

    private List<?> callProcessorUnlocked(Client processor, SmfRecord x) {
        return processor.processRecord(x);
    }

    private void setRecordTypes(SmfRecordReader reader) {
        Iterator<Object> iterator = this.smfTypes.iterator();
        while (iterator.hasNext()) {
            int smfType = iterator.next();
            reader.include(smfType);
        }
        for (SmfTypeSubtype smfType : this.smfTypeSubtypes) {
            reader.include(smfType.smfType, smfType.subType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeJson(Smf2JsonWriter writer, List<?> objects, MultiLineArray<Object> arrayFormatter) throws IOException {
        if (objects != null) {
            Object object = this.writeLock;
            synchronized (object) {
                for (int i = 0; i < objects.size(); ++i) {
                    if (objects.get(i) == FINISHED) {
                        return true;
                    }
                    writer.writeLine(arrayFormatter.element(objects.get(i)));
                }
            }
        }
        return false;
    }

    private static class SmfTypeSubtype {
        int smfType;
        int subType;

        SmfTypeSubtype(int smfType, int subType) {
            this.smfType = smfType;
            this.subType = subType;
        }
    }

    public static interface Client {
        public List<?> processRecord(SmfRecord var1);

        public List<?> onEndOfData();
    }
}

