/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf2json.cli;

import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;

class TakeWhileSpliterator<T>
implements Spliterator<T> {
    private final Spliterator<T> source;
    private final Predicate<T> condition;
    private final boolean inclusive;
    private volatile boolean conditionHeldSoFar = true;
    private TakeWhileSpliterator<T> rootSpliterator;

    static <T> TakeWhileSpliterator<T> over(Spliterator<T> source, Predicate<T> condition) {
        return new TakeWhileSpliterator<T>(source, condition, false, null);
    }

    static <T> TakeWhileSpliterator<T> overInclusive(Spliterator<T> source, Predicate<T> condition) {
        return new TakeWhileSpliterator<T>(source, condition, true, null);
    }

    private TakeWhileSpliterator(Spliterator<T> source, Predicate<T> condition, boolean inclusive, TakeWhileSpliterator<T> rootSpliterator) {
        this.source = source;
        this.condition = condition;
        this.inclusive = inclusive;
        this.rootSpliterator = rootSpliterator == null ? this : rootSpliterator;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        return this.rootSpliterator.conditionHeldSoFar && this.source.tryAdvance(e -> {
            if (this.condition.test(e)) {
                action.accept(e);
            } else {
                if (this.inclusive && this.rootSpliterator.conditionHeldSoFar) {
                    action.accept(e);
                }
                this.rootSpliterator.conditionHeldSoFar = false;
            }
        });
    }

    @Override
    public Spliterator<T> trySplit() {
        Spliterator<T> split = this.source.trySplit();
        if (split == null) {
            return null;
        }
        return new TakeWhileSpliterator<T>(split, this.condition, this.inclusive, this.rootSpliterator);
    }

    @Override
    public long estimateSize() {
        return this.rootSpliterator.conditionHeldSoFar ? this.source.estimateSize() : 0L;
    }

    @Override
    public int characteristics() {
        return this.source.characteristics();
    }

    @Override
    public Comparator<? super T> getComparator() {
        return this.source.getComparator();
    }
}

