/*
 * Decompiled with CFR 0.152.
 */
import com.blackhillsoftware.json.EasySmfGsonBuilder;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.cics.Smf110Record;
import com.blackhillsoftware.smf.cics.monitoring.CicsClock;
import com.blackhillsoftware.smf.cics.monitoring.DictionaryEntry;
import com.blackhillsoftware.smf.cics.monitoring.PerformanceRecord;
import com.blackhillsoftware.smf.cics.monitoring.fields.ClockField;
import com.blackhillsoftware.smf.cics.monitoring.fields.Field;
import com.blackhillsoftware.smf.readerbuilder.LogstreamBuilderLocal;
import com.blackhillsoftware.smf.readerbuilder.ReaderBuilderBase;
import com.google.gson.Gson;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Comparator;

public class Query05ReadLogstream {
    public static void main(String[] args) throws IOException {
        Smf110Record.dictionariesFromName((String)"//'ANDREWR.DEMO.CICS.DICT'");
        Gson gson = new EasySmfGsonBuilder().includeEmptyStrings(false).includeZeroValues(false).includeUnsetFlags(false).cicsClockDetail(false).avoidScientificNotation(true).createGson();
        ReaderBuilderBase builder = ((LogstreamBuilderLocal)SmfRecordReader.logstreamBuilder((String)"IFASMF.CICS").from(LocalDateTime.of(2023, 8, 18, 2, 0)).to(LocalDateTime.of(2023, 8, 18, 23, 0)).sid("S0W1")).include(110, 1);
        try (SmfRecordReader reader = builder.build();){
            reader.stream().map(record -> Smf110Record.from((SmfRecord)record)).filter(r110 -> r110.mnProductSection().smfmnprn().equals("CICSCTAA")).map(r110 -> r110.performanceRecords()).flatMap(Collection::stream).filter(tx -> tx.getField(Field.TERM).equals("0520")).sorted(Comparator.comparing(tx -> tx.getField(Field.START))).forEach(System.out::println);
        }
    }

    private static void printClocks(PerformanceRecord tx) {
        System.out.format("%-4s %-30s Elapsed : %f ", tx.getField(Field.TRAN), tx.getField(Field.START), tx.elapsedSeconds());
        for (DictionaryEntry entry : tx.getDictionary().entries()) {
            CicsClock clock;
            if (!(entry.field() instanceof ClockField) || !((clock = (CicsClock)tx.getField(entry)).timerSeconds() > tx.elapsedSeconds() * 0.1)) continue;
            System.out.format("%-8s : %f  ", entry.cmodhead(), clock.timerSeconds());
        }
        System.out.println();
    }
}

