/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.dcollect;

import com.blackhillsoftware.dcollect.ActiveDataset;
import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.smf.VRecordReader;
import java.io.IOException;
import java.time.LocalDate;

public class AgedDatasets {
    private static boolean includeDataset(ActiveDataset datasetRecord) {
        String datasetName = datasetRecord.dcddsnam();
        if (datasetName.startsWith("SYS1.VTOCIX")) {
            return false;
        }
        return !datasetName.startsWith("SYS1.VVDS");
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: AgedDatasets <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        LocalDate cutoff = LocalDate.now().minusYears(5L);
        System.out.format("%-44s %-6s %15s %15s %10s%n", "Dataset", "VOLSER", "Created", "Last Ref", "Alloc MB");
        try (VRecordReader reader = VRecordReader.fromName(args[0]);){
            reader.stream().map(DcollectRecord::from).filter(r -> r.dcurctyp().equals((Object)DcollectType.D)).map(ActiveDataset::from).filter(record -> record.dcdlstrf() != null && record.dcdlstrf().isBefore(cutoff) || record.dcdlstrf() == null && record.dcdcredt().isBefore(cutoff)).filter(AgedDatasets::includeDataset).forEach(record -> System.out.format("%-44s %-6s %15s %15s %,10.1f%n", record.dcddsnam(), record.dcdvolsr(), record.dcdcredt(), record.dcdlstrf(), record.dcdscalxMB()));
        }
    }
}

