/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.dcollect;

import com.blackhillsoftware.dcollect.ActiveDataset;
import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.smf.VRecordReader;
import com.blackhillsoftware.smf.summary.Top;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeltaDatasets {
    static Pattern gdgPattern = Pattern.compile("(.+)\\.G\\d{4}V\\d{2}$");

    private static boolean includeDataset(ActiveDataset datasetRecord) {
        return datasetRecord.dcdstogp().equals("SG1");
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Usage: DeltaDatasets <input-name-1> <input-name-2>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        HashMap<String, DatasetInfo> datasets = new HashMap<String, DatasetInfo>();
        try (VRecordReader reader = VRecordReader.fromName(args[0]);){
            reader.stream().map(DcollectRecord::from).filter(record -> record.dcurctyp().equals((Object)DcollectType.D)).map(ActiveDataset::from).filter(DeltaDatasets::includeDataset).forEach(datasetrecord -> {
                String name = DeltaDatasets.maskIfGDG(datasetrecord.dcddsnam());
                datasets.computeIfAbsent(name, key -> new DatasetInfo()).addA((ActiveDataset)datasetrecord);
            });
        }
        reader = VRecordReader.fromName(args[1]);
        try {
            reader.stream().map(DcollectRecord::from).filter(record -> record.dcurctyp().equals((Object)DcollectType.D)).map(ActiveDataset::from).filter(DeltaDatasets::includeDataset).forEach(datasetrecord -> {
                String name = DeltaDatasets.maskIfGDG(datasetrecord.dcddsnam());
                datasets.computeIfAbsent(name, key -> new DatasetInfo()).addB((ActiveDataset)datasetrecord);
            });
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        DeltaDatasets.reportDeltas(datasets);
    }

    public static String maskIfGDG(String maybeGdg) {
        Matcher m = gdgPattern.matcher(maybeGdg);
        if (m.matches()) {
            return m.group(1) + ".G####V##";
        }
        return maybeGdg;
    }

    private static void reportDeltas(Map<String, DatasetInfo> datasets) {
        System.out.format("%-44s %12s %12s %12s%n", "Dataset", "MB A", "MB B", "Change MB");
        datasets.entrySet().stream().filter(entry -> ((DatasetInfo)entry.getValue()).absChange() > 0L).collect(Top.values(100, Comparator.comparing(entry -> ((DatasetInfo)entry.getValue()).absChange()))).forEach(entry -> {
            DatasetInfo dataset = (DatasetInfo)entry.getValue();
            System.out.format("%-44s %,12d %,12d %+,12d%n", entry.getKey(), dataset.spaceMBA, dataset.spaceMBB, dataset.deltaSpace());
        });
    }

    private static class DatasetInfo {
        long spaceMBA = 0L;
        long spaceMBB = 0L;

        private DatasetInfo() {
        }

        long deltaSpace() {
            return this.spaceMBB - this.spaceMBA;
        }

        public long absChange() {
            return Math.abs(this.deltaSpace());
        }

        void addA(ActiveDataset ds) {
            this.spaceMBA = (long)((double)this.spaceMBA + ds.dcdallsxMB());
        }

        void addB(ActiveDataset ds) {
            this.spaceMBB = (long)((double)this.spaceMBB + ds.dcdallsxMB());
        }
    }
}

