/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.dcollect;

import com.blackhillsoftware.dcollect.ActiveDataset;
import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.smf.VRecordReader;
import com.blackhillsoftware.smf.summary.Top;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class DeltaHlq {
    private static boolean includeDataset(ActiveDataset datasetRecord) {
        return datasetRecord.dcdstogp().equals("SG1");
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Usage: DeltaHlq <input-name-1> <input-name-2>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        HashMap<String, HlqInfo> hlqs = new HashMap<String, HlqInfo>();
        try (VRecordReader reader = VRecordReader.fromName(args[0]);){
            reader.stream().map(DcollectRecord::from).filter(record -> record.dcurctyp().equals((Object)DcollectType.D)).map(ActiveDataset::from).filter(DeltaHlq::includeDataset).forEach(datasetrecord -> hlqs.computeIfAbsent(DeltaHlq.hlq(datasetrecord.dcddsnam()), key -> new HlqInfo()).addA((ActiveDataset)datasetrecord));
        }
        reader = VRecordReader.fromName(args[1]);
        try {
            reader.stream().map(DcollectRecord::from).filter(record -> record.dcurctyp().equals((Object)DcollectType.D)).map(ActiveDataset::from).filter(DeltaHlq::includeDataset).forEach(datasetrecord -> hlqs.computeIfAbsent(DeltaHlq.hlq(datasetrecord.dcddsnam()), key -> new HlqInfo()).addB((ActiveDataset)datasetrecord));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        DeltaHlq.reportDeltas(hlqs);
    }

    private static String hlq(String dsn) {
        String[] qualifiers = dsn.split("\\.", 2);
        return qualifiers[0];
    }

    private static void reportDeltas(Map<String, HlqInfo> hlqs) {
        System.out.format("%-8s %10s %10s %10s %12s %12s %12s%n", "HLQ", "Count A", "Count B", "Change", "MB A", "MB B", "Change MB");
        hlqs.entrySet().stream().filter(entry -> ((HlqInfo)entry.getValue()).absChange() > 0L).collect(Top.values(50, Comparator.comparing(entry -> ((HlqInfo)entry.getValue()).absChange()))).forEach(entry -> {
            HlqInfo hlqinfo = (HlqInfo)entry.getValue();
            System.out.format("%-8s %,10d %,10d %+,10d %,12d %,12d %+,12d%n", entry.getKey(), hlqinfo.countA, hlqinfo.countB, hlqinfo.deltaCount(), hlqinfo.spaceMBA, hlqinfo.spaceMBB, hlqinfo.deltaSpace());
        });
    }

    private static class HlqInfo {
        int countA = 0;
        long spaceMBA = 0L;
        int countB = 0;
        long spaceMBB = 0L;

        private HlqInfo() {
        }

        int deltaCount() {
            return this.countB - this.countA;
        }

        long deltaSpace() {
            return this.spaceMBB - this.spaceMBA;
        }

        public long absChange() {
            return Math.abs(this.deltaSpace());
        }

        void addA(ActiveDataset ds) {
            ++this.countA;
            this.spaceMBA = (long)((double)this.spaceMBA + ds.dcdallsxMB());
        }

        void addB(ActiveDataset ds) {
            ++this.countB;
            this.spaceMBB = (long)((double)this.spaceMBB + ds.dcdallsxMB());
        }
    }
}

