/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.dcollect;

import com.blackhillsoftware.dcollect.ActiveDataset;
import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.MigratedDataset;
import com.blackhillsoftware.smf.VRecordReader;
import java.io.IOException;
import java.util.HashMap;

public class MbByHlq {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: MbByHlq <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        HashMap totalsByHlq = new HashMap();
        try (VRecordReader reader = VRecordReader.fromName(args[0]);){
            reader.stream().map(DcollectRecord::from).forEach(record -> {
                switch (record.dcurctyp()) {
                    case D: {
                        ActiveDataset dataset = ActiveDataset.from(record);
                        totalsByHlq.computeIfAbsent(MbByHlq.hlq(dataset.dcddsnam()), key -> new SpaceInformation()).add(dataset);
                        break;
                    }
                    case M: {
                        MigratedDataset dataset = MigratedDataset.from(record);
                        totalsByHlq.computeIfAbsent(MbByHlq.hlq(dataset.umdsnam()), key -> new SpaceInformation()).add(dataset);
                        break;
                    }
                }
            });
        }
        System.out.format("%-8s %8s %10s %8s %10s %10s %8s %10s %8s %10s%n", "HLQ", "Count", "Total MB", "Level0", "Alloc MB", "Used MB", "ML1", "ML1 MB", "ML2", "ML2 MB");
        totalsByHlq.entrySet().stream().sorted((a, b) -> Double.compare(((SpaceInformation)b.getValue()).totalMB, ((SpaceInformation)a.getValue()).totalMB)).forEachOrdered(entry -> System.out.format("%-8s %,8d %10.0f %,8d %10.0f %10.0f %,8d %10.0f %,8d %10.0f%n", entry.getKey(), ((SpaceInformation)entry.getValue()).count, ((SpaceInformation)entry.getValue()).totalMB, ((SpaceInformation)entry.getValue()).level0Count, ((SpaceInformation)entry.getValue()).level0Alloc, ((SpaceInformation)entry.getValue()).level0UsedMB, ((SpaceInformation)entry.getValue()).level1Count, ((SpaceInformation)entry.getValue()).level1MB, ((SpaceInformation)entry.getValue()).level2Count, ((SpaceInformation)entry.getValue()).level2MB));
    }

    private static String hlq(String dsn) {
        String[] qualifiers = dsn.split("\\.", 2);
        return qualifiers[0];
    }

    private static class SpaceInformation {
        int count = 0;
        double totalMB = 0.0;
        int level0Count = 0;
        double level0Alloc = 0.0;
        double level0UsedMB = 0.0;
        int level1Count = 0;
        double level1MB = 0.0;
        int level2Count = 0;
        double level2MB = 0.0;

        private SpaceInformation() {
        }

        void add(ActiveDataset datasetRecord) {
            ++this.count;
            ++this.level0Count;
            this.totalMB += datasetRecord.dcdallsxMB();
            this.level0Alloc += datasetRecord.dcdallsxMB();
            this.level0UsedMB += datasetRecord.dcdusesxMB();
        }

        void add(MigratedDataset datasetRecord) {
            ++this.count;
            double space = datasetRecord.umrecspMB();
            this.totalMB += space;
            switch (datasetRecord.umlevel()) {
                case LEVEL1: {
                    ++this.level1Count;
                    this.level1MB += space;
                    break;
                }
                case LEVEL2: {
                    ++this.level2Count;
                    this.level2MB += space;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected migration level: " + String.valueOf((Object)datasetRecord.umlevel()));
                }
            }
        }
    }
}

