/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.dcollect;

import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.dcollect.MigratedDataset;
import com.blackhillsoftware.smf.VRecordReader;
import com.blackhillsoftware.smf.summary.Top;
import java.io.IOException;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;

public class MigrationFrequency {
    private static boolean includeDataset(MigratedDataset dataset) {
        String datasetName = dataset.umdsnam();
        return true;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: MigrationFrequency <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        LocalDate runtime = LocalDate.now();
        LocalDate cutoff = runtime.minusMonths(3L);
        System.out.format("%-44s %-15s %-15s %7s %7s %10s%n", "Dataset", "Created", "Migrated", "Count", "Freq", "Size MB");
        try (VRecordReader reader = VRecordReader.fromName(args[0]);){
            reader.stream().map(DcollectRecord::from).filter(r -> r.dcurctyp().equals((Object)DcollectType.M)).map(MigratedDataset::from).filter(r -> r.umnmig() > 2).filter(r -> r.umdate().isAfter(cutoff)).filter(r -> r.umstgcl().length() > 0).filter(r -> MigrationFrequency.includeDataset(r)).collect(Top.values(100, Comparator.comparing(r -> MigrationFrequency.frequency(r, runtime)))).forEach(record -> System.out.format("%-44s %-15s %-15s %7d %7.1f %,10.1f%n", record.umdsnam(), record.umcredt(), record.ummdate().toLocalDate(), record.umnmig(), MigrationFrequency.frequency(record, runtime), record.umrecspMB()));
        }
    }

    private static double frequency(MigratedDataset dataset, LocalDate runtime) {
        long days = dataset.umcredt().until(runtime, ChronoUnit.DAYS);
        return (double)dataset.umnmig() / (double)days * 365.0;
    }
}

