/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.dcollect;

import com.blackhillsoftware.dcollect.ActiveDataset;
import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.smf.VRecordReader;
import java.io.IOException;
import java.util.HashMap;

public class ZedcByHlq {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: ZedcByHlq <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        HashMap zedcByHlq = new HashMap();
        try (VRecordReader reader = VRecordReader.fromName(args[0]);){
            reader.stream().map(DcollectRecord::from).filter(r -> r.dcurctyp().equals((Object)DcollectType.D)).map(ActiveDataset::from).filter(r -> r.dcdcmptv() && r.dcdczedc()).forEach(record -> {
                String hlq = ZedcByHlq.hlq(record.dcddsnam());
                zedcByHlq.computeIfAbsent(hlq, key -> new ZedcSummary()).add((ActiveDataset)record);
            });
        }
        System.out.format("%-8s %8s %12s %12s %7s%n", "HLQ", "Count", "Comp MB", "Uncomp MB", "Comp%");
        zedcByHlq.entrySet().stream().sorted((a, b) -> Double.compare(((ZedcSummary)b.getValue()).compressed, ((ZedcSummary)a.getValue()).compressed)).forEachOrdered(entry -> System.out.format("%-8s %,8d %,12.0f %,12.0f %7.1f%n", entry.getKey(), ((ZedcSummary)entry.getValue()).count, ((ZedcSummary)entry.getValue()).compressed, ((ZedcSummary)entry.getValue()).uncompressed, ((ZedcSummary)entry.getValue()).savedPct()));
    }

    private static String hlq(String dsn) {
        String[] qualifiers = dsn.split("\\.", 2);
        return qualifiers[0];
    }

    private static class ZedcSummary {
        int count = 0;
        double compressed = 0.0;
        double uncompressed = 0.0;

        private ZedcSummary() {
        }

        void add(ActiveDataset ds) {
            ++this.count;
            this.compressed += ds.dcdcudszMB();
            this.uncompressed += ds.dcdudsizMB();
        }

        double savedPct() {
            return (1.0 - this.compressed / this.uncompressed) * 100.0;
        }
    }
}

