/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.common;

import com.blackhillsoftware.common.JzosFunctions;
import com.blackhillsoftware.common.Message;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyManager {
    private static Map<String, List<String>> keys = new ConcurrentHashMap<String, List<String>>();

    public static void setKey(String name, List<String> key) {
        keys.put(name, key);
    }

    public static List<String> getKey(String name) {
        return keys.get(name);
    }

    public static List<String> getKey(String owner, String ddname, String envname) {
        Objects.requireNonNull(owner);
        Objects.requireNonNull(ddname);
        Objects.requireNonNull(envname);
        Logger slf4jLogger = LoggerFactory.getLogger((String)owner);
        String osname = System.getProperty("os.name").toLowerCase(Locale.US);
        boolean zos = osname.indexOf("z/os") > -1;
        return keys.computeIfAbsent(ddname, k -> {
            String keylocation = null;
            try {
                keylocation = zos && JzosFunctions.ddExists(ddname) ? "//DD:" + ddname : System.getenv(envname);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (keylocation != null) {
                ArrayList<String> key = new ArrayList<String>();
                try (InputStream stream = zos ? JzosFunctions.newInputStream(keylocation) : new FileInputStream(keylocation);){
                    String str;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                    while ((str = reader.readLine()) != null) {
                        key.add(str);
                    }
                }
                catch (IOException e) {
                    Message.box(arg_0 -> ((Logger)slf4jLogger).error(arg_0), Arrays.asList("Unable to read key file:", e.getMessage()));
                    System.exit(1);
                }
                return key;
            }
            Message.box(arg_0 -> ((Logger)slf4jLogger).error(arg_0), Arrays.asList(ddname + " DD not found and ", envname + " environment variable not set"));
            System.exit(1);
            return null;
        });
    }
}

