/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.zutil.mvs;

import com.ibm.jzos.MvsCommandCallback;
import com.ibm.jzos.MvsConsole;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;

public class CommandHandler {
    private static Object lockObject = new Object();
    private static String startArgs = null;
    private static boolean registered = false;
    private static MvsCommandCallback oldCallback = null;
    private static List<CommandHandler> onModifyCmds = new ArrayList<CommandHandler>();
    private static List<CommandHandler> onStopCmds = new ArrayList<CommandHandler>();
    private Function<String, Boolean> onModify = null;
    private BooleanSupplier onStop = null;

    private CommandHandler() {
    }

    private static void register() {
        try {
            if (!MvsConsole.isListening()) {
                MvsConsole.startMvsCommandListener();
            }
            oldCallback = MvsConsole.registerMvsCommandCallback((MvsCommandCallback)new Handler());
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("MVS command callback registration failed:");
            System.err.println(e.getMessage());
            System.err.println("MVS command handling is not available.");
        }
        registered = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onStart(Consumer<String> onStartFunction) {
        Object object = lockObject;
        synchronized (object) {
            if (!registered) {
                CommandHandler.register();
            }
            Objects.requireNonNull(onStartFunction);
            if (startArgs != null) {
                onStartFunction.accept(startArgs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommandHandler onModify(Function<String, Boolean> onModifyFunction) {
        Object object = lockObject;
        synchronized (object) {
            if (!registered) {
                CommandHandler.register();
            }
            Objects.requireNonNull(onModifyFunction);
            CommandHandler handler = new CommandHandler();
            handler.onModify = onModifyFunction;
            onModifyCmds.add(0, handler);
            return handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommandHandler onStop(BooleanSupplier onStopFunction) {
        Object object = lockObject;
        synchronized (object) {
            if (!registered) {
                CommandHandler.register();
            }
            Objects.requireNonNull(onStopFunction);
            CommandHandler handler = new CommandHandler();
            handler.onStop = onStopFunction;
            onStopCmds.add(0, handler);
            return handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeModify(CommandHandler onModifyHandler) {
        Object object = lockObject;
        synchronized (object) {
            Objects.requireNonNull(onModifyHandler);
            return onModifyCmds.remove(onModifyHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeStop(CommandHandler onStopHandler) {
        Object object = lockObject;
        synchronized (object) {
            Objects.requireNonNull(onStopHandler);
            return onStopCmds.remove(onStopHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAll() {
        Object object = lockObject;
        synchronized (object) {
            onModifyCmds.clear();
            onStopCmds.clear();
        }
    }

    private static class Handler
    implements MvsCommandCallback {
        private Handler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleModify(String command) {
            Object object = lockObject;
            synchronized (object) {
                if (oldCallback == null && onModifyCmds.isEmpty()) {
                    MvsConsole.wto((String)"Modify not implemented", (int)32, (int)16);
                } else {
                    boolean handled = this.tryHandleModify(command);
                    if (!handled) {
                        MvsConsole.wto((String)("Modify comand not recognized : " + command), (int)32, (int)16);
                    }
                }
            }
        }

        public void handleStart(String arg0) {
            startArgs = arg0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleStop() {
            Object object = lockObject;
            synchronized (object) {
                if (onStopCmds.isEmpty() && oldCallback == null) {
                    return true;
                }
                boolean result = false;
                for (CommandHandler handler : new ArrayList(onStopCmds)) {
                    result = handler.onStop.getAsBoolean() || result;
                }
                if (oldCallback != null) {
                    result = oldCallback.handleStop() || result;
                }
                return result;
            }
        }

        private boolean tryHandleModify(String command) {
            for (CommandHandler handler : new ArrayList(onModifyCmds)) {
                boolean handled = (Boolean)handler.onModify.apply(command);
                if (!handled) continue;
                return true;
            }
            if (oldCallback != null) {
                oldCallback.handleModify(command);
                return true;
            }
            return false;
        }
    }
}

