/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.sample;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.realtime.MissedDataEvent;
import com.blackhillsoftware.smf.realtime.SmfConnection;
import com.blackhillsoftware.smf.smf70.Smf70Record;
import com.blackhillsoftware.smf.smf72.Smf72Record;
import com.blackhillsoftware.smf.smf72.subtype3.ServiceReportClassPeriodDataSection;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class SmtSwitch {
    private static final double SMTOFF = 80.0;
    private static final double SMTON = 50.0;
    private static Interval currentInterval = null;

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: SmtSwitch <resource-name>");
            return;
        }
        String inMemoryResource = args[0];
        try (SmfConnection connection = SmfConnection.forResourceName((String)inMemoryResource).onMissedData(SmtSwitch::handleMissedData).disconnectOnStop().connect();
             SmfRecordReader reader = SmfRecordReader.fromByteArrays((Iterable<byte[]>)connection).include(70, 1).include(72, 3);){
            SmtSwitch.readRecords(reader);
        }
    }

    private static void readRecords(SmfRecordReader reader) {
        for (SmfRecord record : reader) {
            switch (record.recordType()) {
                case 70: {
                    Smf70Record r70 = Smf70Record.from(record);
                    if (currentInterval == null || !SmtSwitch.currentInterval.intervalToken.equals(r70.productSection().smf70iet().withZoneSameInstant(r70.productSection().smf70lgo()))) {
                        currentInterval = new Interval(r70, currentInterval);
                    }
                    currentInterval.add(r70);
                    break;
                }
                case 72: {
                    Smf72Record r72 = Smf72Record.from(record);
                    if (currentInterval == null || !SmtSwitch.currentInterval.intervalToken.equals(r72.productSection().smf72iet().withZoneSameInstant(r72.productSection().smf72lgo()))) {
                        currentInterval = new Interval(r72, currentInterval);
                    }
                    currentInterval.add(r72);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unexpected record type: " + record.recordType());
                }
            }
            if (!currentInterval.isComplete() || !(SmtSwitch.currentInterval.intervalLength > SmtSwitch.currentInterval.originalIntervalLength * 0.75) || SmtSwitch.currentInterval.processed) continue;
            SmtSwitch.processInterval();
        }
    }

    private static void processInterval() {
        Optional<Double> ziipVelocity = currentInterval.ziipVelocity();
        boolean smt2 = currentInterval.isSmt2();
        System.out.format("%-35s SMT2: %s zIIP Velocity: %3.0f Thresholds %2.0f %2.0f%n", SmtSwitch.currentInterval.intervalToken, smt2, ziipVelocity.orElse(null), 50.0, 80.0);
        if (!ziipVelocity.isPresent()) {
            return;
        }
        if (smt2 && ziipVelocity.get() > 80.0) {
            System.out.println("TURN SMT OFF");
        } else if (!smt2 && ziipVelocity.get() < 50.0) {
            System.out.println("TURN SMT ON");
        }
        SmtSwitch.currentInterval.processed = true;
    }

    static void handleMissedData(MissedDataEvent e) {
        System.out.println("Missed Data!");
        e.throwException(false);
    }

    private static class Interval {
        ZonedDateTime intervalToken;
        double intervalLength;
        double originalIntervalLength;
        boolean processed = false;
        private List<Smf70Record> smf70Records = new ArrayList<Smf70Record>();
        private List<ServiceReportClassPeriodDataSection> serviceClasses = new ArrayList<ServiceReportClassPeriodDataSection>();
        private int expectedSmf70Records = 0;
        private int expectedServiceClasses = 0;

        Interval(Smf70Record r70, Interval current) {
            this.intervalToken = r70.productSection().smf70iet().withZoneSameInstant(r70.productSection().smf70lgo());
            this.intervalLength = r70.productSection().smf70intSeconds();
            this.originalIntervalLength = r70.productSection().smf70oilSeconds();
            if (current != null && current.serviceClasses.size() > 0) {
                this.expectedServiceClasses = current.serviceClasses.size();
            }
        }

        Interval(Smf72Record r72, Interval current) {
            this.intervalToken = r72.productSection().smf72iet().withZoneSameInstant(r72.productSection().smf72lgo());
            this.intervalLength = r72.productSection().smf72intSeconds();
            this.originalIntervalLength = r72.productSection().smf72oilSeconds();
            if (current != null && current.serviceClasses.size() > 0) {
                this.expectedServiceClasses = current.serviceClasses.size();
            }
        }

        void add(Smf70Record r70) {
            if (this.expectedSmf70Records == 0) {
                this.expectedSmf70Records = r70.productSection().smf70ran() == 0 ? 1 : r70.productSection().reassemblyArea().smf70rbr();
            }
            this.smf70Records.add(r70);
        }

        void add(Smf72Record r72) {
            if (!r72.workloadManagerControlSection().r723mrcl()) {
                this.serviceClasses.addAll(r72.serviceReportClassPeriodDataSections());
            }
        }

        boolean isComplete() {
            return this.expectedServiceClasses != 0 && this.expectedSmf70Records != 0 && this.serviceClasses.size() >= this.expectedServiceClasses && this.smf70Records.size() >= this.expectedSmf70Records;
        }

        boolean isSmt2() {
            boolean smt2 = this.smf70Records.stream().map(r70 -> r70.logicalCoreDataSections()).flatMap(Collection::stream).filter(core -> core.smf70CpuNum() > 1).findFirst().isPresent();
            return smt2;
        }

        Optional<Double> ziipVelocity() {
            double ziipUsing = 0.0;
            double ziipDelay = 0.0;
            for (ServiceReportClassPeriodDataSection serviceClass : this.serviceClasses) {
                ziipUsing += (double)serviceClass.r723supu();
                ziipDelay += (double)serviceClass.r723supd();
            }
            if (ziipUsing == 0.0 && ziipDelay == 0.0) {
                return Optional.empty();
            }
            return Optional.of(ziipUsing / (ziipUsing + ziipDelay) * 100.0);
        }
    }
}

