/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.sample;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.realtime.MissedDataEvent;
import com.blackhillsoftware.smf.realtime.SmfConnection;
import java.io.IOException;

public class RtiSimple {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: RtiSimple <resource-name>");
            return;
        }
        String inMemoryResource = args[0];
        try (SmfConnection connection = SmfConnection.forResourceName((String)inMemoryResource).onMissedData(RtiSimple::handleMissedData).disconnectOnStop().connect();){
            connection.stream().limit(100L).forEach(record -> {
                SmfRecord smfrecord = new SmfRecord((byte[])record);
                System.out.format("%-24s record type: %4d size: %5d%n", smfrecord.smfDateTime(), smfrecord.recordType(), smfrecord.length());
            });
        }
    }

    static void handleMissedData(MissedDataEvent e) {
        System.out.println("Missed Data!");
        e.throwException(false);
    }
}

