/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class RecordCount {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: RecordCount <input-name> [<input-name> ...]");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        HashMap<Integer, Map<Integer, RecordStats>> statsMap = new HashMap<Integer, Map<Integer, RecordStats>>();
        RecordStats totals = new RecordStats(-1, -1);
        for (String inputName : args) {
            try (SmfRecordReader reader = SmfRecordReader.fromName((String)inputName);){
                for (SmfRecord record : reader) {
                    totals.add(record);
                    int type = record.recordType();
                    int subtype = record.hasSubtypes() ? record.subType() : 0;
                    statsMap.computeIfAbsent(type, key -> new HashMap()).computeIfAbsent(subtype, key -> new RecordStats(type, subtype)).add(record);
                }
            }
        }
        RecordCount.writeReport(statsMap, totals);
    }

    private static void writeReport(Map<Integer, Map<Integer, RecordStats>> statsMap, RecordStats totals) {
        long totalbytes = statsMap.entrySet().stream().map(entry -> (Map)entry.getValue()).flatMap(entry -> entry.entrySet().stream()).mapToLong(entry -> ((RecordStats)entry.getValue()).getBytes()).sum();
        System.out.format("%5s %8s %11s %11s %7s %9s %9s %9s %n", "Type", "Subtype", "Records", "MB", "Pct", "Min", "Max", "Avg");
        statsMap.entrySet().stream().map(entry -> (Map)entry.getValue()).flatMap(entry -> entry.entrySet().stream()).map(entry -> (RecordStats)entry.getValue()).sorted(Comparator.comparingLong(RecordStats::getBytes).reversed()).forEachOrdered(entry -> System.out.format("%5d %8d %11d %11d %7.1f %9d %9d %9d %n", entry.getRecordtype(), entry.getSubtype(), entry.getCount(), entry.getBytes() / 0x100000L, Float.valueOf(totalbytes > 0L ? (float)entry.getBytes() / (float)totalbytes * 100.0f : 0.0f), entry.getMinLength(), entry.getMaxLength(), entry.getCount() > 0 ? entry.getBytes() / (long)entry.getCount() : 0L));
        System.out.format("%n%-14s %11d %11d %7.1f %9d %9d %9d %n", "Total:", totals.getCount(), totals.getBytes() / 0x100000L, Float.valueOf(totalbytes > 0L ? (float)totals.getBytes() / (float)totalbytes * 100.0f : 0.0f), totals.getMinLength(), totals.getMaxLength(), totals.getCount() > 0 ? totals.getBytes() / (long)totals.getCount() : 0L);
    }

    private static class RecordStats {
        private int recordtype;
        private int subtype;
        private int count = 0;
        private long bytes = 0L;
        private int maxLength = 0;
        private int minLength = 0;

        RecordStats(int recordType, int subType) {
            this.recordtype = recordType;
            this.subtype = subType;
        }

        public void add(SmfRecord record) {
            ++this.count;
            int length = record.recordLength();
            this.bytes += (long)length;
            this.minLength = this.minLength == 0 || length < this.minLength ? length : this.minLength;
            this.maxLength = length > this.maxLength ? length : this.maxLength;
        }

        int getRecordtype() {
            return this.recordtype;
        }

        int getSubtype() {
            return this.subtype;
        }

        int getCount() {
            return this.count;
        }

        long getBytes() {
            return this.bytes;
        }

        int getMaxLength() {
            return this.maxLength;
        }

        int getMinLength() {
            return this.minLength;
        }
    }
}

