/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.cics;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.Utils;
import com.blackhillsoftware.smf.cics.Smf110Record;
import com.blackhillsoftware.smf.cics.monitoring.PerformanceRecord;
import com.blackhillsoftware.smf.cics.monitoring.fields.Field;
import com.blackhillsoftware.smf.smf72.Smf72Record;
import com.blackhillsoftware.smf.smf72.subtype3.ServiceReportClassPeriodDataSection;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;

public class CicsServiceClass {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: CicsServiceClass <input-name> <input-name2> ...");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        HashMap<String, Map<String, Map<String, TransactionData>>> txByApplidServiceClassTxName = new HashMap<String, Map<String, Map<String, TransactionData>>>();
        HashMap<String, Map<String, TransactionData>> txByApplidServiceClassAll = new HashMap<String, Map<String, TransactionData>>();
        HashMap<String, ServiceClassInfo> serviceClasses = new HashMap<String, ServiceClassInfo>();
        int noDictionary = 0;
        int txCount = 0;
        for (String name : args) {
            try (SmfRecordReader reader = SmfRecordReader.fromName((String)name).include(110, 1).include(72, 3);){
                block10: for (SmfRecord record : reader) {
                    switch (record.recordType()) {
                        case 110: {
                            Smf110Record r110 = Smf110Record.from((SmfRecord)record);
                            if (r110.haveDictionary()) {
                                String applid = r110.mnProductSection().smfmnprn();
                                for (PerformanceRecord transaction : r110.performanceRecords()) {
                                    ++txCount;
                                    txByApplidServiceClassTxName.computeIfAbsent(applid, key -> new HashMap()).computeIfAbsent(transaction.getField(Field.SRVCLSNM), key -> new HashMap()).computeIfAbsent(transaction.getField(Field.TRAN), key -> new TransactionData()).add(transaction);
                                    txByApplidServiceClassAll.computeIfAbsent(applid, key -> new HashMap()).computeIfAbsent(transaction.getField(Field.SRVCLSNM), key -> new TransactionData()).add(transaction);
                                }
                                continue block10;
                            }
                            ++noDictionary;
                            break;
                        }
                        case 72: {
                            String serviceClass;
                            Smf72Record r72 = Smf72Record.from((SmfRecord)record);
                            if (r72.workloadManagerControlSection().r723mrcl() || serviceClasses.containsKey(serviceClass = r72.workloadManagerControlSection().r723mcnm()) && !r72.smfDateTime().isAfter(((ServiceClassInfo)serviceClasses.get(serviceClass)).getTime())) break;
                            serviceClasses.put(serviceClass, new ServiceClassInfo(r72));
                        }
                    }
                }
            }
        }
        CicsServiceClass.writeReport(txByApplidServiceClassAll, txByApplidServiceClassTxName, serviceClasses);
        System.out.format("%n%nTotal Transactions: %,d%n", txCount);
        if (noDictionary > 0) {
            System.out.format("%n%nSkipped %,d records because no applicable dictionary was found.", noDictionary);
        }
        if (Smf110Record.getCompressedByteCount() > 0L) {
            System.out.format("%n%nCompressed bytes %,d, decompressed bytes %,d, compression %.1f%%.%n", Smf110Record.getCompressedByteCount(), Smf110Record.getDecompressedByteCount(), (double)(Smf110Record.getDecompressedByteCount() - Smf110Record.getCompressedByteCount()) / (double)Smf110Record.getDecompressedByteCount() * 100.0);
        }
    }

    private static void writeReport(Map<String, Map<String, TransactionData>> txByApplidServiceClassAll, Map<String, Map<String, Map<String, TransactionData>>> txByApplidServiceClassTxName, Map<String, ServiceClassInfo> serviceClasses) {
        txByApplidServiceClassAll.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(applidEntry -> CicsServiceClass.reportApplid((String)applidEntry.getKey(), (Map)txByApplidServiceClassAll.get(applidEntry.getKey()), (Map)txByApplidServiceClassTxName.get(applidEntry.getKey()), serviceClasses));
    }

    private static void reportApplid(String applid, Map<String, TransactionData> txByServiceClassAll, Map<String, Map<String, TransactionData>> txByServiceClassTxName, Map<String, ServiceClassInfo> serviceClasses) {
        System.out.format("%nAPPLID: %-8s%n", applid);
        txByServiceClassAll.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(servClassEntry -> CicsServiceClass.reportServiceClass((String)servClassEntry.getKey(), (TransactionData)txByServiceClassAll.get(servClassEntry.getKey()), (Map)txByServiceClassTxName.get(servClassEntry.getKey()), serviceClasses));
    }

    private static void reportServiceClass(String serviceClass, TransactionData txAll, Map<String, TransactionData> txByTxName, Map<String, ServiceClassInfo> serviceClasses) {
        System.out.format("%n    Service Class: %-8s Description : %s Goal: %s%n", serviceClass, serviceClasses.containsKey(serviceClass) ? serviceClasses.get(serviceClass).getDescription() : "", serviceClasses.containsKey(serviceClass) ? serviceClasses.get(serviceClass).getGoal() : "");
        String headerfmt = "%n        %-4s %15s %15s %15s %15s %15s %15s%n%n";
        String detailfmt = "        %-4s %15d %15f %15f %15f %15f %15f%n";
        System.out.format("%n        %-4s %15s %15s %15s %15s %15s %15s%n%n", "Name", "Count", "Tot CPU", "Avg CPU", "Avg Elapsed", "Max Elapsed", "Std Dev");
        System.out.format("        %-4s %15d %15f %15f %15f %15f %15f%n", "ALL", txAll.getCount(), txAll.getCpu(), txAll.getAvgCpu(), txAll.getAvgElapsed(), txAll.getMaxElapsed(), txAll.getStandardDeviation());
        System.out.println();
        txByTxName.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(txEntry -> System.out.format("        %-4s %15d %15f %15f %15f %15f %15f%n", txEntry.getKey(), ((TransactionData)txEntry.getValue()).getCount(), ((TransactionData)txEntry.getValue()).getCpu(), ((TransactionData)txEntry.getValue()).getAvgCpu(), ((TransactionData)txEntry.getValue()).getAvgElapsed(), ((TransactionData)txEntry.getValue()).getMaxElapsed(), ((TransactionData)txEntry.getValue()).getStandardDeviation()));
    }

    private static class TransactionData {
        private int count = 0;
        private double totalElapsed = 0.0;
        private double maxElapsed = 0.0;
        private double cpu = 0.0;
        private StandardDeviation sd = new StandardDeviation(false);

        private TransactionData() {
        }

        public void add(PerformanceRecord txData) {
            ++this.count;
            double elapsed = Utils.ToSeconds((Duration)Duration.between(txData.getField(Field.START), txData.getField(Field.STOP)));
            this.maxElapsed = this.maxElapsed > elapsed ? this.maxElapsed : elapsed;
            this.totalElapsed += elapsed;
            this.cpu += txData.getField(Field.USRCPUT).timerSeconds();
            this.sd.increment(elapsed);
        }

        public int getCount() {
            return this.count;
        }

        public Double getMaxElapsed() {
            return this.maxElapsed;
        }

        public Double getAvgElapsed() {
            return this.count != 0 ? Double.valueOf(this.totalElapsed / (double)this.count) : null;
        }

        public Double getCpu() {
            return this.cpu;
        }

        public Double getAvgCpu() {
            return this.count != 0 ? Double.valueOf(this.cpu / (double)this.count) : null;
        }

        public Double getStandardDeviation() {
            return this.sd.getResult();
        }
    }

    private static class ServiceClassInfo {
        private LocalDateTime time;
        private String description;
        private String goal;

        ServiceClassInfo(Smf72Record r72) {
            this.time = r72.smfDateTime();
            this.description = r72.workloadManagerControlSection().r723mcde();
            this.goal = ((ServiceReportClassPeriodDataSection)r72.serviceReportClassPeriodDataSections().get(0)).goalDescription();
        }

        LocalDateTime getTime() {
            return this.time;
        }

        String getDescription() {
            return this.description;
        }

        String getGoal() {
            return this.goal;
        }
    }
}

