/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.cics;

import com.blackhillsoftware.json.EasySmfGsonBuilder;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.cics.Smf110Record;
import com.google.gson.Gson;
import java.io.IOException;

public class CicsTransactionSearch {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: CicsTransactionSearch <input-name> <input-name2> ...");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        Gson gson = new EasySmfGsonBuilder().setPrettyPrinting().avoidScientificNotation(true).cicsClockDetail(false).includeZeroValues(false).includeUnsetFlags(false).includeEmptyStrings(false).createGson();
        for (String name : args) {
            try (SmfRecordReader reader = SmfRecordReader.fromName((String)name).include(110, 1);){
                reader.stream().map(r110 -> Smf110Record.from((SmfRecord)r110)).filter(r110 -> r110.haveDictionary()).map(r110 -> r110.performanceRecords()).flatMap(entries -> entries.stream()).filter(tx -> tx.elapsedSeconds() > 5.0).limit(1000L).forEachOrdered(tx -> System.out.println(tx.toString()));
            }
        }
    }
}

