/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.cics;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.Utils;
import com.blackhillsoftware.smf.cics.Smf110Record;
import com.blackhillsoftware.smf.cics.monitoring.PerformanceRecord;
import com.blackhillsoftware.smf.cics.monitoring.fields.Field;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class CicsTransactionSummary {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: CicsTransactionSummary <input-name> <input-name2> ...");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        HashMap<String, Map<String, TransactionData>> applids = new HashMap<String, Map<String, TransactionData>>();
        int noDictionary = 0;
        int txCount = 0;
        for (String name : args) {
            try (SmfRecordReader reader = SmfRecordReader.fromName((String)name);){
                reader.include(110, 1);
                for (SmfRecord record : reader) {
                    Smf110Record r110 = Smf110Record.from((SmfRecord)record);
                    if (r110.haveDictionary()) {
                        Map applidTransactions = applids.computeIfAbsent(r110.mnProductSection().smfmnprn(), transactions -> new HashMap());
                        for (PerformanceRecord txData : r110.performanceRecords()) {
                            String txName = txData.getField(Field.TRAN);
                            ++txCount;
                            applidTransactions.computeIfAbsent(txName, x -> new TransactionData(txName)).add(txData);
                        }
                        continue;
                    }
                    ++noDictionary;
                }
            }
        }
        CicsTransactionSummary.writeReport(applids);
        System.out.format("%n%nTotal Transactions: %,d%n", txCount);
        if (noDictionary > 0) {
            System.out.format("%n%nSkipped %,d records because no applicable dictionary was found.", noDictionary);
        }
        if (Smf110Record.getCompressedByteCount() > 0L) {
            System.out.format("%n%nCompressed bytes %,d, decompressed bytes %,d, compression %.1f%%.%n", Smf110Record.getCompressedByteCount(), Smf110Record.getDecompressedByteCount(), (double)(Smf110Record.getDecompressedByteCount() - Smf110Record.getCompressedByteCount()) / (double)Smf110Record.getDecompressedByteCount() * 100.0);
        }
    }

    private static void writeReport(Map<String, Map<String, TransactionData>> transactions) {
        transactions.entrySet().stream().sorted((a, b) -> ((String)a.getKey()).compareTo((String)b.getKey())).forEachOrdered(applid -> {
            System.out.format("%n%-8s", applid.getKey());
            System.out.format("%n%-4s %15s %15s %15s %15s %15s %15s%n%n", "Name", "Count", "Avg Elapsed", "CPU", "Avg CPU", "Avg Disp.", "Avg Disp Wait");
            ((Map)applid.getValue()).entrySet().stream().map(x -> (TransactionData)x.getValue()).sorted(Comparator.comparing(TransactionData::getCpu, Collections.reverseOrder()).thenComparing(TransactionData::getCount, Collections.reverseOrder())).forEachOrdered(txInfo -> System.out.format("%-4s %15d %15f %15f %15f %15f %15f%n", txInfo.getName(), txInfo.getCount(), txInfo.getAvgElapsed(), txInfo.getCpu(), txInfo.getAvgCpu(), txInfo.getAvgDispatch(), txInfo.getAvgDispatchWait()));
        });
    }

    private static class TransactionData {
        private String name;
        private int count = 0;
        private double elapsed = 0.0;
        private double dispatch = 0.0;
        private double dispatchWait = 0.0;
        private double cpu = 0.0;

        public TransactionData(String name) {
            this.name = name;
        }

        public void add(PerformanceRecord txData) {
            ++this.count;
            this.elapsed += Utils.ToSeconds((Duration)Duration.between(txData.getField(Field.START), txData.getField(Field.STOP)));
            this.dispatch += txData.getField(Field.USRDISPT).timerSeconds();
            this.dispatchWait += txData.getField(Field.DISPWTT).timerSeconds();
            this.cpu += txData.getField(Field.USRCPUT).timerSeconds();
        }

        public String getName() {
            return this.name;
        }

        public int getCount() {
            return this.count;
        }

        public double getCpu() {
            return this.cpu;
        }

        public Double getAvgElapsed() {
            return this.count != 0 ? Double.valueOf(this.elapsed / (double)this.count) : null;
        }

        public Double getAvgDispatch() {
            return this.count != 0 ? Double.valueOf(this.dispatch / (double)this.count) : null;
        }

        public Double getAvgDispatchWait() {
            return this.count != 0 ? Double.valueOf(this.dispatchWait / (double)this.count) : null;
        }

        public Double getAvgCpu() {
            return this.count != 0 ? Double.valueOf(this.cpu / (double)this.count) : null;
        }
    }
}

