/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.cics;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.SmfRecordWriter;
import com.blackhillsoftware.smf.cics.Smf110Record;
import java.io.IOException;

public class ExtractDictionaries {
    private static void printUsage() {
        System.out.println("Usage: ExtractDictionaries input-file output-file");
        System.out.println("");
        System.out.println("Search for CICS Dictionaries in input-file and write them to output-file");
        System.out.println("");
        System.out.println("  input-file   File containing SMF records. Binary data, RECFM=U or V[B]");
        System.out.println("               including RDW.");
        System.out.println("  output-file  Output-file for dictionaries.");
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2 || args[0].equals("--help") || args[0].equals("-h")) {
            ExtractDictionaries.printUsage();
            System.exit(0);
        }
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)args[0]);
             SmfRecordWriter writer = SmfRecordWriter.fromName((String)args[1]);){
            reader.include(110, 1);
            int in = 0;
            int out = 0;
            for (SmfRecord record : reader) {
                Smf110Record r110 = Smf110Record.from((SmfRecord)record);
                ++in;
                if (!r110.mnProductSection().monitoringClassDictionary()) continue;
                ++out;
                writer.write(record);
            }
            System.out.format("Finished, %d records in, %d records out.%n", in, out);
        }
        catch (Exception e) {
            ExtractDictionaries.printUsage();
            throw e;
        }
    }
}

