/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.cics;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.SmfRecordWriter;
import com.blackhillsoftware.smf.cics.Smf110Record;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;

public class FilterRecords {
    private static List<String> applids = Arrays.asList("CN1PPA1", "CN1PPA2");
    private static List<LocalDate> days = Arrays.asList(LocalDate.of(2025, 9, 10), LocalDate.of(2025, 9, 17));

    private static void printUsage() {
        System.out.println("Usage: FilterRecords <input-file> <output-file>");
        System.out.println("");
        System.out.println("Filter CICS SMF records to exclude records that are not required and speed up subsequent reports");
        System.out.println("");
        System.out.println("  input-file   File containing SMF records. Binary data, RECFM=U or V[B]");
        System.out.println("               including RDW.");
        System.out.println("  output-file  Output-file.");
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2 || args[0].equals("--help") || args[0].equals("-h")) {
            FilterRecords.printUsage();
            System.exit(0);
        }
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)args[0]).include(110);
             SmfRecordWriter writer = SmfRecordWriter.fromName((String)args[1]);){
            int in = 0;
            int out = 0;
            for (SmfRecord record : reader) {
                Smf110Record r110 = Smf110Record.from((SmfRecord)record);
                ++in;
                if (!FilterRecords.include(r110)) continue;
                ++out;
                writer.write(record);
            }
            System.out.format("Finished, %d records in, %d records out.%n", in, out);
        }
        catch (Exception e) {
            FilterRecords.printUsage();
            throw e;
        }
    }

    private static boolean include(Smf110Record r110) {
        if (!applids.contains(FilterRecords.applid(r110))) {
            return false;
        }
        return days.contains(r110.smfDate());
    }

    private static String applid(Smf110Record r110) {
        switch (r110.subType()) {
            case 0: {
                return r110.jcProductSection().smfpsprn();
            }
            case 1: {
                return r110.mnProductSection().smfmnprn();
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return r110.stProductSection().smfstprn();
            }
        }
        return "Unknown";
    }
}

